/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.compat.sodium;

import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockRenderer.class}, remap=false)
public abstract class SodiumLevelRenderCompatMixin {
    @Inject(method={"getVertexColors"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void colorfullighting$ensureWhiteAndTint(BlockRenderContext ctx, ColorProvider<BlockState> colorProvider, BakedQuadView quad, CallbackInfoReturnable<int[]> cir) {
        int[] colors = (int[])cir.getReturnValue();
        if (colors == null) {
            colors = new int[]{-1, -1, -1, -1};
        } else {
            for (int i = 0; i < colors.length; ++i) {
                if ((colors[i] & 0xFFFFFF) != 0) continue;
                colors[i] = colors[i] & 0xFF000000 | 0xFFFFFF;
            }
        }
        ColoredLightEngine eng = ColoredLightEngine.getInstance();
        if (eng != null && ctx != null && quad != null) {
            for (int i = 0; i < 4; ++i) {
                double wx = (float)ctx.pos().m_123341_() + quad.getX(i);
                double wy = (float)ctx.pos().m_123342_() + quad.getY(i);
                double wz = (float)ctx.pos().m_123343_() + quad.getZ(i);
                ColorRGB8 c = eng.sampleTrilinearLightColor(new Vec3(wx, wy, wz));
                int rc = c.red & 0xFF;
                int gc = c.green & 0xFF;
                int bc = c.blue & 0xFF;
                int maxc = Math.max(rc, Math.max(gc, bc));
                if (maxc == 0) continue;
                int abgr = colors[i];
                int a = abgr >>> 24 & 0xFF;
                int b = abgr >>> 16 & 0xFF;
                int g = abgr >>> 8 & 0xFF;
                int r = abgr & 0xFF;
                float intensity = (float)Math.pow((float)maxc / 255.0f, 1.25);
                float rN = (float)rc / (float)maxc;
                float gN = (float)gc / (float)maxc;
                float bN = (float)bc / (float)maxc;
                rN = (float)Math.pow(rN, 0.75);
                gN = (float)Math.pow(gN, 0.75);
                bN = (float)Math.pow(bN, 0.75);
                float falloff = (float)a / 255.0f;
                falloff *= falloff;
                float mr = 1.0f + (intensity *= falloff) * (rN - 1.0f);
                float mg = 1.0f + intensity * (gN - 1.0f);
                float mb = 1.0f + intensity * (bN - 1.0f);
                int nr = SodiumLevelRenderCompatMixin.colorfullighting$clamp255(Math.round((float)r * mr));
                int ng = SodiumLevelRenderCompatMixin.colorfullighting$clamp255(Math.round((float)g * mg));
                int nb = SodiumLevelRenderCompatMixin.colorfullighting$clamp255(Math.round((float)b * mb));
                colors[i] = a << 24 | nb << 16 | ng << 8 | nr;
            }
        }
        cir.setReturnValue((Object)colors);
    }

    @Unique
    private static int colorfullighting$clamp255(int v) {
        return v < 0 ? 0 : Math.min(v, 255);
    }
}

