/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.render;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import me.erykczy.colorfullighting.common.util.PackedLightData;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrightnessCombiner.class})
public class BrightnessCombinerMixin {
    private static int unpackBlock(int packed) {
        return packed >> 4 & 0xF;
    }

    private static int unpackSky(int packed) {
        return packed >> 20 & 0xF;
    }

    private static int pack(int block, int sky) {
        return block << 4 | sky << 20;
    }

    private static int maxPacked(int a, int b) {
        return BrightnessCombinerMixin.pack(Math.max(BrightnessCombinerMixin.unpackBlock(a), BrightnessCombinerMixin.unpackBlock(b)), Math.max(BrightnessCombinerMixin.unpackSky(a), BrightnessCombinerMixin.unpackSky(b)));
    }

    private static int safeLight(BlockEntity be) {
        if (be == null) {
            return 0;
        }
        Level lvl = be.m_58904_();
        if (lvl == null) {
            return 0;
        }
        return LevelRenderer.m_109541_((BlockAndTintGetter)lvl, (BlockPos)be.m_58899_());
    }

    @Inject(method={"acceptDouble(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/level/block/entity/BlockEntity;)Lit/unimi/dsi/fastutil/ints/Int2IntFunction;"}, at={@At(value="HEAD")}, cancellable=true)
    private <S extends BlockEntity> void cl$acceptDouble(S first, S second, CallbackInfoReturnable<Int2IntFunction> cir) {
        int a = BrightnessCombinerMixin.safeLight(first);
        int b = BrightnessCombinerMixin.safeLight(second);
        if (ModList.get().isLoaded("embeddium")) {
            cir.setReturnValue(base -> BrightnessCombinerMixin.maxPacked(BrightnessCombinerMixin.maxPacked(base, a), b));
            cir.cancel();
        } else {
            cir.setReturnValue(base -> PackedLightData.max(PackedLightData.max(base, a), b));
            cir.cancel();
        }
    }

    @Inject(method={"acceptSingle(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lit/unimi/dsi/fastutil/ints/Int2IntFunction;"}, at={@At(value="HEAD")}, cancellable=true)
    private <S extends BlockEntity> void cl$acceptSingle(S be, CallbackInfoReturnable<Int2IntFunction> cir) {
        int beLight = BrightnessCombinerMixin.safeLight(be);
        if (ModList.get().isLoaded("embeddium")) {
            cir.setReturnValue(base -> BrightnessCombinerMixin.maxPacked(base, beLight));
            cir.cancel();
        } else {
            cir.setReturnValue(base -> PackedLightData.max(base, beLight));
            cir.cancel();
        }
    }
}

