/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.render;

import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.erykczy.colorfullighting.common.util.PackedLightData;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Inject(method={"getPackedLightCoords"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void colorfullighting$getPackedLightCoords(T entity, float partialTicks, CallbackInfoReturnable<Integer> cir) {
        if (ModList.get().isLoaded("embeddium")) {
            BlockPos pos = BlockPos.m_274446_((Position)entity.m_7371_(partialTicks));
            int block = entity.m_6060_() ? 15 : entity.m_9236_().m_45517_(LightLayer.BLOCK, pos);
            int sky = entity.m_9236_().m_45517_(LightLayer.SKY, pos);
            cir.setReturnValue((Object)LightTexture.m_109885_((int)block, (int)sky));
        } else {
            BlockPos blockpos = BlockPos.m_274446_((Position)entity.m_7371_(partialTicks));
            int skyLight = entity.m_6060_() ? 15 : entity.m_9236_().m_45517_(LightLayer.SKY, blockpos);
            ColorRGB8 color = ColoredLightEngine.getInstance().sampleTrilinearLightColor(entity.m_7371_(partialTicks));
            cir.setReturnValue((Object)PackedLightData.packData(skyLight, color));
        }
    }
}

