/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.render;

import me.erykczy.colorfullighting.accessors.BlockStateWrapper;
import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.Config;
import me.erykczy.colorfullighting.common.accessors.LevelAccessor;
import me.erykczy.colorfullighting.common.util.ColorRGB4;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.erykczy.colorfullighting.common.util.PackedLightData;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Inject(method={"getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void colorfullighting$getLightColor(BlockAndTintGetter level, BlockState state, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (ModList.get().isLoaded("embeddium")) {
            int sky = level.m_45517_(LightLayer.SKY, pos);
            int block = level.m_45517_(LightLayer.BLOCK, pos);
            int emission = state.getLightEmission((BlockGetter)level, pos);
            block = Math.max(block, emission);
            if (state.m_60788_((BlockGetter)level, pos)) {
                block = 15;
                sky = 15;
            }
            cir.setReturnValue((Object)LightTexture.m_109885_((int)block, (int)sky));
        } else {
            int skyLight = level.m_45517_(LightLayer.SKY, pos);
            if (state.m_60788_((BlockGetter)level, pos)) {
                LevelAccessor levelAccessor = ColoredLightEngine.getInstance().clientAccessor.getLevel();
                BlockStateWrapper stateAccessor = new BlockStateWrapper(state);
                if (levelAccessor != null) {
                    ColorRGB4 emission = Config.getLightColor(stateAccessor);
                    int skyAtt = LevelRendererMixin.colorful_lighting$attenuateSky(skyLight, emission);
                    cir.setReturnValue((Object)PackedLightData.packData(skyAtt, ColorRGB8.fromRGB4(emission)));
                    return;
                }
                cir.setReturnValue((Object)PackedLightData.packData(15, 255, 255, 255));
                return;
            }
            ColorRGB4 color = ColoredLightEngine.getInstance().sampleLightColor(pos);
            int skyAtt = LevelRendererMixin.colorful_lighting$attenuateSky(skyLight, color);
            cir.setReturnValue((Object)PackedLightData.packData(skyAtt, ColorRGB8.fromRGB4(color)));
        }
    }

    @Unique
    private static int colorful_lighting$attenuateSky(int sky4, ColorRGB4 c) {
        float r = c.red4 & 0xF;
        float g = c.green4 & 0xF;
        float b = c.blue4 & 0xF;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        if (max <= 0.0f) {
            return sky4;
        }
        float strength = max / 15.0f;
        float sat = (max - min) / max;
        float k = 1.0f * strength * (0.6f + 0.4f * sat);
        int atten = Math.round((float)sky4 * (1.0f - k));
        if (atten < 0) {
            atten = 0;
        }
        if (atten > 15) {
            atten = 15;
        }
        return atten;
    }
}

