/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.flowerary;

import com.github.mnesikos.flowerary.block.FloweraryBlocks;
import com.github.mnesikos.flowerary.client.color.ColorEvents;
import com.github.mnesikos.flowerary.data.FloweraryBlockModels;
import com.github.mnesikos.flowerary.data.FloweraryBlockStates;
import com.github.mnesikos.flowerary.data.FloweraryItemModels;
import com.github.mnesikos.flowerary.data.FloweraryLootTables;
import com.github.mnesikos.flowerary.data.FloweraryRecipes;
import com.github.mnesikos.flowerary.data.FloweraryTags;
import com.github.mnesikos.flowerary.item.FlowerComposting;
import com.github.mnesikos.flowerary.item.FloweraryColor;
import com.github.mnesikos.flowerary.item.FloweraryItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="flowerary")
public class Flowerary {
    public static final String MOD_ID = "flowerary";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"flowerary");
    public static final RegistryObject<CreativeModeTab> FLOWERARY_GROUP = CREATIVE_MODE_TABS.register("flowerary.flowerary_group", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.flowerary.flowerary_group")).m_257737_(() -> ((Block)FloweraryBlocks.POPPIES.get(FloweraryColor.PINK.m_7912_()).get()).m_5456_().m_7968_()).m_257501_((itemDisplayParameters, output) -> FloweraryItems.REGISTRAR.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get()))).m_257652_());

    public Flowerary() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FloweraryBlocks.REGISTRAR.register(bus);
        FloweraryItems.REGISTRAR.register(bus);
        FloweraryItems.TABLESS_REGISTRAR.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::gatherData);
        bus.addListener(this::setupClient);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(ColorEvents::registerColorHandlerBlocks);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(FlowerComposting::registerCompostables);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new FloweraryBlockModels(packOutput, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new FloweraryBlockStates(packOutput, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new FloweraryItemModels(packOutput, event.getExistingFileHelper()));
        FloweraryTags.FloweraryBlockTags blockTagsProvider = new FloweraryTags.FloweraryBlockTags(packOutput, event.getLookupProvider(), event.getExistingFileHelper());
        dataGenerator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new FloweraryTags.FloweraryItemTags(packOutput, event.getLookupProvider(), blockTagsProvider, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(FloweraryLootTables::new, LootContextParamSets.f_81421_))));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new FloweraryRecipes(packOutput));
    }

    private void setupClient(FMLClientSetupEvent event) {
        FloweraryBlocks.setRenderLayers();
    }
}

