/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.flowerary.block;

import com.github.mnesikos.flowerary.block.FlowerBlock;
import com.github.mnesikos.flowerary.block.FlowerBushBlock;
import com.github.mnesikos.flowerary.block.FlowerCarpetBlock;
import com.github.mnesikos.flowerary.block.FlowerCropBlock;
import com.github.mnesikos.flowerary.block.TallFlowerBlock;
import com.github.mnesikos.flowerary.block.TallFlowerCropBlock;
import com.github.mnesikos.flowerary.item.FloweraryColor;
import com.github.mnesikos.flowerary.item.FloweraryItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class FloweraryBlocks {
    public static final DeferredRegister<Block> REGISTRAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"flowerary");
    public static final Map<String, RegistryObject<Block>> ALLIUM = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ALYSSUM = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> AZURE_BLUET = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BLAZING_STAR = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BOUGAINVILLEA = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BROMELIAD = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CHICORY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CLEMATIS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CLOVER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CORNFLOWER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DAFFODIL = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DAISY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DANDELION = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DIANTHUS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FAIRY_ROSE = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FOXGLOVE = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> HIBISCUS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> HYACINTH = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> IMPALA_LILY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> JASMINE = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LANTANAS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LAVENDER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LILAC = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LILY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ORCHID = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PEONY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PETALS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PITCHER_PLANT = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POPPY = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POPPIES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE_BUSH = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE_BUSHLET = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> SUNFLOWER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> TORCHFLOWER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> TULIP = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> WILDFLOWER = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> WITHER_ROSE = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_ALLIUMS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_AZURE_BLUETS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_CORNFLOWERS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_DAFFODILS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_DAISYS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_DANDELIONS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_FAIRY_ROSES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_HYACINTHS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_LILYS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_ORCHIDS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_POPPYS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_ROSES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_TORCHFLOWERS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_TULIPS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POTTED_WITHER_ROSES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ALLIUM_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ALYSSUM_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> AZURE_BLUET_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BLAZING_STAR_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BOUGAINVILLEA_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> BROMELIAD_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CHICORY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CLEMATIS_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CLOVER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CORNFLOWER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DAFFODIL_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DAISY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DANDELION_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DIANTHUS_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FAIRY_ROSE_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FOXGLOVE_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> HIBISCUS_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> HYACINTH_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> IMPALA_LILY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> JASMINE_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LANTANAS_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LAVENDER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LILAC_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LILY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ORCHID_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PEONY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PETALS_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PITCHER_PLANT_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POPPY_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> POPPIES_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE_BUSH_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> ROSE_BUSHLET_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> SUNFLOWER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> TORCHFLOWER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> TULIP_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> WILDFLOWER_PLANTS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> WITHER_ROSE_PLANTS = new HashMap<String, RegistryObject<Block>>();

    private static void registerTallFlower(String color, String flower, Map<String, RegistryObject<Block>> flowersMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new TallFlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50357_))));
    }

    private static void registerFlowerAndCrop(String color, String flower, Map<String, RegistryObject<Block>> flowersMap, Map<String, RegistryObject<Block>> cropsMap, Map<String, RegistryObject<Item>> seedsMap, Map<String, RegistryObject<Block>> pottedsMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new FlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_222979_(BlockBehaviour.OffsetType.XZ))));
        cropsMap.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_" + flower + "_plant", () -> new FlowerCropBlock((Supplier)seedsMap.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
        if (pottedsMap != null) {
            pottedsMap.put(color, (RegistryObject<Block>)REGISTRAR.register("potted_" + color + "_" + flower, () -> new FlowerPotBlock((Block)((RegistryObject)flowersMap.get(color)).get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50233_))));
        }
    }

    private static void registerFlowerCarpetAndCrop(String color, String flower, Map<String, RegistryObject<Block>> flowersMap, Map<String, RegistryObject<Block>> cropsMap, Map<String, RegistryObject<Item>> seedsMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new FlowerCarpetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_222979_(BlockBehaviour.OffsetType.NONE))));
        cropsMap.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_" + flower + "_plant", () -> new FlowerCropBlock((Supplier)seedsMap.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
    }

    private static void registerPetalsAndCrop(String color, String flower, Map<String, RegistryObject<Block>> flowersMap, Map<String, RegistryObject<Block>> cropsMap, Map<String, RegistryObject<Item>> seedsMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new PinkPetalsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_222979_(BlockBehaviour.OffsetType.NONE))));
        cropsMap.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_" + flower + "_plant", () -> new FlowerCropBlock((Supplier)seedsMap.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
    }

    private static void registerFlowerVineAndCrop(String color, String flower, Map<String, RegistryObject<Block>> flowersMap, Map<String, RegistryObject<Block>> cropsMap, Map<String, RegistryObject<Item>> seedsMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new VineBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_))));
        cropsMap.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_" + flower + "_plant", () -> new FlowerCropBlock((Supplier)seedsMap.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
    }

    private static void registerFlowerBushAndCrop(String color, String flower, Map<String, RegistryObject<Block>> flowersMap, Map<String, RegistryObject<Block>> cropsMap, Map<String, RegistryObject<Item>> seedsMap) {
        flowersMap.put(color, FloweraryBlocks.registerWithItem(color + "_" + flower, () -> new FlowerBushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_222979_(BlockBehaviour.OffsetType.XZ))));
        cropsMap.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_" + flower + "_plant", () -> new FlowerCropBlock((Supplier)seedsMap.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<T> block) {
        RegistryObject registryObject = REGISTRAR.register(name, block);
        FloweraryItems.REGISTRAR.register(name, () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
        return registryObject;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        REGISTRAR.getEntries().stream().map(RegistryObject::get).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)cutout));
    }

    static {
        for (FloweraryColor floweraryColor : FloweraryColor.values()) {
            String color = floweraryColor.m_7912_();
            FloweraryBlocks.registerFlowerAndCrop(color, "allium", ALLIUM, ALLIUM_PLANTS, FloweraryItems.ALLIUM_SEEDS, POTTED_ALLIUMS);
            FloweraryBlocks.registerFlowerCarpetAndCrop(color, "alyssum", ALYSSUM, ALYSSUM_PLANTS, FloweraryItems.ALYSSUM_SEEDS);
            FloweraryBlocks.registerFlowerAndCrop(color, "azure_bluet", AZURE_BLUET, AZURE_BLUET_PLANTS, FloweraryItems.AZURE_BLUET_SEEDS, POTTED_AZURE_BLUETS);
            FloweraryBlocks.registerTallFlower(color, "blazing_star", BLAZING_STAR);
            BLAZING_STAR_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_blazing_star_plant", () -> new TallFlowerCropBlock.BlazingStarCropBlock((Supplier)FloweraryItems.BLAZING_STAR_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerVineAndCrop(color, "bougainvillea", BOUGAINVILLEA, BOUGAINVILLEA_PLANTS, FloweraryItems.BOUGAINVILLEA_SEEDS);
            FloweraryBlocks.registerFlowerBushAndCrop(color, "bromeliad", BROMELIAD, BROMELIAD_PLANTS, FloweraryItems.BROMELIAD_SEEDS);
            FloweraryBlocks.registerFlowerBushAndCrop(color, "chicory", CHICORY, CHICORY_PLANTS, FloweraryItems.CHICORY_SEEDS);
            FloweraryBlocks.registerFlowerVineAndCrop(color, "clematis", CLEMATIS, CLEMATIS_PLANTS, FloweraryItems.CLEMATIS_SEEDS);
            FloweraryBlocks.registerFlowerCarpetAndCrop(color, "clover", CLOVER, CLOVER_PLANTS, FloweraryItems.CLOVER_SEEDS);
            FloweraryBlocks.registerFlowerAndCrop(color, "cornflower", CORNFLOWER, CORNFLOWER_PLANTS, FloweraryItems.CORNFLOWER_SEEDS, POTTED_CORNFLOWERS);
            FloweraryBlocks.registerFlowerAndCrop(color, "daffodil", DAFFODIL, DAFFODIL_PLANTS, FloweraryItems.DAFFODIL_SEEDS, POTTED_DAFFODILS);
            FloweraryBlocks.registerFlowerAndCrop(color, "daisy", DAISY, DAISY_PLANTS, FloweraryItems.DAISY_SEEDS, POTTED_DAISYS);
            FloweraryBlocks.registerFlowerAndCrop(color, "dandelion", DANDELION, DANDELION_PLANTS, FloweraryItems.DANDELION_SEEDS, POTTED_DANDELIONS);
            FloweraryBlocks.registerFlowerAndCrop(color, "dianthus", DIANTHUS, DIANTHUS_PLANTS, FloweraryItems.DIANTHUS_SEEDS, null);
            FloweraryBlocks.registerFlowerAndCrop(color, "fairy_rose", FAIRY_ROSE, FAIRY_ROSE_PLANTS, FloweraryItems.FAIRY_ROSE_SEEDS, POTTED_FAIRY_ROSES);
            FloweraryBlocks.registerTallFlower(color, "foxglove", FOXGLOVE);
            FOXGLOVE_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_foxglove_plant", () -> new TallFlowerCropBlock.FoxgloveCropBlock((Supplier)FloweraryItems.FOXGLOVE_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerBushAndCrop(color, "hibiscus", HIBISCUS, HIBISCUS_PLANTS, FloweraryItems.HIBISCUS_SEEDS);
            FloweraryBlocks.registerFlowerAndCrop(color, "hyacinth", HYACINTH, HYACINTH_PLANTS, FloweraryItems.HYACINTH_SEEDS, POTTED_HYACINTHS);
            FloweraryBlocks.registerTallFlower(color, "impala_lily", IMPALA_LILY);
            IMPALA_LILY_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_impala_lily_plant", () -> new TallFlowerCropBlock.ImpalaLilyCropBlock((Supplier)FloweraryItems.IMPALA_LILY_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerVineAndCrop(color, "jasmine", JASMINE, JASMINE_PLANTS, FloweraryItems.JASMINE_SEEDS);
            FloweraryBlocks.registerFlowerBushAndCrop(color, "lantanas", LANTANAS, LANTANAS_PLANTS, FloweraryItems.LANTANAS_SEEDS);
            FloweraryBlocks.registerTallFlower(color, "lavender", LAVENDER);
            LAVENDER_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_lavender_plant", () -> new TallFlowerCropBlock.LavenderCropBlock((Supplier)FloweraryItems.LAVENDER_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerTallFlower(color, "lilac", LILAC);
            LILAC_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_lilac_plant", () -> new TallFlowerCropBlock.LilacCropBlock((Supplier)FloweraryItems.LILAC_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerAndCrop(color, "lily", LILY, LILY_PLANTS, FloweraryItems.LILY_SEEDS, POTTED_LILYS);
            FloweraryBlocks.registerFlowerAndCrop(color, "orchid", ORCHID, ORCHID_PLANTS, FloweraryItems.ORCHID_SEEDS, POTTED_ORCHIDS);
            FloweraryBlocks.registerTallFlower(color, "peony", PEONY);
            PEONY_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_peony_plant", () -> new TallFlowerCropBlock.PeonyCropBlock((Supplier)FloweraryItems.PEONY_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerPetalsAndCrop(color, "petals", PETALS, PETALS_PLANTS, FloweraryItems.PETALS_SEEDS);
            FloweraryBlocks.registerTallFlower(color, "pitcher_plant", PITCHER_PLANT);
            PITCHER_PLANT_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_pitcher_plant_plant", () -> new TallFlowerCropBlock.PitcherPlantCropBlock((Supplier)FloweraryItems.PITCHER_PLANT_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerAndCrop(color, "poppy", POPPY, POPPY_PLANTS, FloweraryItems.POPPY_SEEDS, POTTED_POPPYS);
            FloweraryBlocks.registerFlowerBushAndCrop(color, "poppies", POPPIES, POPPIES_PLANTS, FloweraryItems.POPPIES_SEEDS);
            FloweraryBlocks.registerFlowerAndCrop(color, "rose", ROSE, ROSE_PLANTS, FloweraryItems.ROSE_SEEDS, POTTED_ROSES);
            FloweraryBlocks.registerTallFlower(color, "rose_bush", ROSE_BUSH);
            ROSE_BUSH_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_rose_bush_plant", () -> new TallFlowerCropBlock.RoseBushCropBlock((Supplier)FloweraryItems.ROSE_BUSH_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerBushAndCrop(color, "rose_bushlet", ROSE_BUSHLET, ROSE_BUSHLET_PLANTS, FloweraryItems.ROSE_BUSHLET_SEEDS);
            FloweraryBlocks.registerTallFlower(color, "sunflower", SUNFLOWER);
            SUNFLOWER_PLANTS.put(color, (RegistryObject<Block>)REGISTRAR.register(color + "_sunflower_plant", () -> new TallFlowerCropBlock.SunflowerCropBlock((Supplier)FloweraryItems.SUNFLOWER_SEEDS.get(color), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))));
            FloweraryBlocks.registerFlowerAndCrop(color, "torchflower", TORCHFLOWER, TORCHFLOWER_PLANTS, FloweraryItems.TORCHFLOWER_SEEDS, POTTED_TORCHFLOWERS);
            FloweraryBlocks.registerFlowerAndCrop(color, "tulip", TULIP, TULIP_PLANTS, FloweraryItems.TULIP_SEEDS, POTTED_TULIPS);
            FloweraryBlocks.registerFlowerBushAndCrop(color, "wildflower", WILDFLOWER, WILDFLOWER_PLANTS, FloweraryItems.WILDFLOWER_SEEDS);
            FloweraryBlocks.registerFlowerAndCrop(color, "wither_rose", WITHER_ROSE, WITHER_ROSE_PLANTS, FloweraryItems.WITHER_ROSE_SEEDS, POTTED_WITHER_ROSES);
        }
    }
}

