/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.flowerary.block;

import com.github.mnesikos.flowerary.block.FlowerCropBlock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TallFlowerCropBlock
extends FlowerCropBlock {
    public static final EnumProperty<DoubleBlockHalf> SEGMENT = BlockStateProperties.f_61401_;
    private final int upperSegmentAge;
    private final VoxelShape[] bottomShape;
    private final VoxelShape[] topShape;

    public TallFlowerCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties, int upperSegmentAge, VoxelShape[] bottomShape, VoxelShape[] topShape) {
        super(seedItem, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_(SEGMENT, (Comparable)DoubleBlockHalf.LOWER));
        this.upperSegmentAge = upperSegmentAge;
        this.bottomShape = bottomShape;
        this.topShape = topShape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        if (state.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER) {
            return this.bottomShape[(Integer)state.m_61143_((Property)f_52244_)];
        }
        return this.topShape[(Integer)state.m_61143_((Property)f_52244_)];
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        DoubleBlockHalf stateSegment = (DoubleBlockHalf)state.m_61143_(SEGMENT);
        if (facing.m_122434_() != Direction.Axis.Y || stateSegment == DoubleBlockHalf.LOWER != (facing == Direction.UP) || !this.isDouble(state) || facingState.m_60713_((Block)this) && facingState.m_61143_(SEGMENT) != stateSegment) {
            return stateSegment == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean isDouble(BlockState state) {
        return this.m_52305_(state) >= this.upperSegmentAge;
    }

    public int getUpperSegmentAge() {
        return this.upperSegmentAge;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return pos.m_123342_() < 255 ? super.m_5573_(context) : null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER) {
            return super.m_7898_(state, level, pos);
        }
        if (!this.isDouble(state)) {
            return false;
        }
        BlockState lowerState = level.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return lowerState.m_60713_((Block)this) && lowerState.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER && this.m_52305_(state) == this.m_52305_(lowerState);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.m_61143_(SEGMENT) == DoubleBlockHalf.UPPER) {
            return;
        }
        int age = this.m_52305_(state);
        if (this.m_7370_((LevelReader)level, pos, state, level.f_46443_) && state.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            int growthAge = age + 1;
            if (growthAge >= this.getUpperSegmentAge()) {
                level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(growthAge))).m_61124_(SEGMENT, (Comparable)DoubleBlockHalf.UPPER));
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(growthAge)), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                TallFlowerCropBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                TallFlowerCropBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tileEntity, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), tileEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos lowerPos;
        BlockState lowerState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(SEGMENT);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (lowerState = level.m_8055_(lowerPos = pos.m_7495_())).m_60734_() == state.m_60734_() && lowerState.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER) {
            level.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_(), SEGMENT});
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(SEGMENT) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public boolean canGrowUp(BlockGetter level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return aboveState.m_60734_() instanceof TallFlowerCropBlock || aboveState.m_247087_();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return !this.m_52307_(state) && (this.canGrowUp((BlockGetter)level, pos) || this.m_52305_(state) < this.getUpperSegmentAge() - 1);
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(SEGMENT) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        int growthAge = this.m_52305_(state) + this.m_7125_(level);
        if ((growthAge = Math.min(growthAge, this.m_7419_())) >= this.getUpperSegmentAge()) {
            if (!this.canGrowUp((BlockGetter)level, pos)) {
                return;
            }
            level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(growthAge).m_61124_(SEGMENT, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        level.m_7731_(pos, this.m_52289_(growthAge), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        PlayerInteractEvent.RightClickBlock event;
        InteractionResult old = super.m_6227_(state, level, pos, player, hand, rayTraceResult);
        if (!old.m_19077_() && this.isDouble(state) && state.m_61143_(SEGMENT) == DoubleBlockHalf.UPPER && (event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)pos.m_7495_(), (BlockHitResult)rayTraceResult)).isCancelable()) {
            return event.getCancellationResult();
        }
        return old;
    }

    public static class SunflowerCropBlock
    extends TallFlowerCropBlock {
        public SunflowerCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 3, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()});
        }
    }

    public static class RoseBushCropBlock
    extends TallFlowerCropBlock {
        public RoseBushCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 2, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class PitcherPlantCropBlock
    extends TallFlowerCropBlock {
        public PitcherPlantCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 2, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class PeonyCropBlock
    extends TallFlowerCropBlock {
        public PeonyCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 2, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class LilacCropBlock
    extends TallFlowerCropBlock {
        public LilacCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 2, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class LavenderCropBlock
    extends TallFlowerCropBlock {
        public LavenderCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 5, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class ImpalaLilyCropBlock
    extends TallFlowerCropBlock {
        public ImpalaLilyCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 5, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class FoxgloveCropBlock
    extends TallFlowerCropBlock {
        public FoxgloveCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 3, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Shapes.m_83144_()});
        }
    }

    public static class BlazingStarCropBlock
    extends TallFlowerCropBlock {
        public BlazingStarCropBlock(Supplier<? extends Item> seedItem, BlockBehaviour.Properties properties) {
            super(seedItem, properties, 3, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()}, new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Shapes.m_83144_()});
        }
    }
}

