/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.flowerary.item;

import com.github.mnesikos.flowerary.block.FloweraryBlocks;
import com.github.mnesikos.flowerary.item.FloweraryColor;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class PollenJarItem
extends Item {
    public static final Object2ObjectMap<Block, Tuple<Map<String, RegistryObject<Block>>, Map<String, RegistryObject<Block>>>> PLANTS_BY_BLOCK = (Object2ObjectMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)Blocks.f_50111_, (Object)new Tuple(FloweraryBlocks.DANDELION_PLANTS, FloweraryBlocks.WILDFLOWER_PLANTS));
        map.put((Object)Blocks.f_50112_, (Object)new Tuple(FloweraryBlocks.POPPIES_PLANTS, FloweraryBlocks.POPPY_PLANTS));
        map.put((Object)Blocks.f_50113_, (Object)new Tuple(FloweraryBlocks.ORCHID_PLANTS, FloweraryBlocks.LANTANAS_PLANTS));
        map.put((Object)Blocks.f_50114_, (Object)new Tuple(FloweraryBlocks.ALLIUM_PLANTS, FloweraryBlocks.DAFFODIL_PLANTS));
        map.put((Object)Blocks.f_50115_, (Object)new Tuple(FloweraryBlocks.AZURE_BLUET_PLANTS, FloweraryBlocks.DIANTHUS_PLANTS));
        map.put((Object)Blocks.f_50116_, (Object)new Tuple(FloweraryBlocks.TULIP_PLANTS, FloweraryBlocks.HYACINTH_PLANTS));
        map.put((Object)Blocks.f_50117_, (Object)new Tuple(FloweraryBlocks.TULIP_PLANTS, FloweraryBlocks.BOUGAINVILLEA_PLANTS));
        map.put((Object)Blocks.f_50118_, (Object)new Tuple(FloweraryBlocks.TULIP_PLANTS, FloweraryBlocks.CLEMATIS_PLANTS));
        map.put((Object)Blocks.f_50119_, (Object)new Tuple(FloweraryBlocks.TULIP_PLANTS, FloweraryBlocks.JASMINE_PLANTS));
        map.put((Object)Blocks.f_50120_, (Object)new Tuple(FloweraryBlocks.DAISY_PLANTS, FloweraryBlocks.CLOVER_PLANTS));
        map.put((Object)Blocks.f_50121_, (Object)new Tuple(FloweraryBlocks.CORNFLOWER_PLANTS, FloweraryBlocks.CHICORY_PLANTS));
        map.put((Object)Blocks.f_50071_, (Object)new Tuple(FloweraryBlocks.LILY_PLANTS, FloweraryBlocks.HIBISCUS_PLANTS));
        map.put((Object)Blocks.f_271329_, (Object)new Tuple(FloweraryBlocks.TORCHFLOWER_PLANTS, FloweraryBlocks.BROMELIAD_PLANTS));
        map.put((Object)Blocks.f_50070_, (Object)new Tuple(FloweraryBlocks.WITHER_ROSE_PLANTS, FloweraryBlocks.FAIRY_ROSE_PLANTS));
        map.put((Object)Blocks.f_271445_, (Object)new Tuple(FloweraryBlocks.PETALS_PLANTS, FloweraryBlocks.ALYSSUM_PLANTS));
        map.put((Object)Blocks.f_50355_, (Object)new Tuple(FloweraryBlocks.SUNFLOWER_PLANTS, FloweraryBlocks.BLAZING_STAR_PLANTS));
        map.put((Object)Blocks.f_50356_, (Object)new Tuple(FloweraryBlocks.LILAC_PLANTS, FloweraryBlocks.LAVENDER_PLANTS));
        map.put((Object)Blocks.f_50357_, (Object)new Tuple(FloweraryBlocks.ROSE_BUSH_PLANTS, FloweraryBlocks.ROSE_BUSHLET_PLANTS));
        map.put((Object)Blocks.f_50358_, (Object)new Tuple(FloweraryBlocks.PEONY_PLANTS, FloweraryBlocks.FOXGLOVE_PLANTS));
        map.put((Object)Blocks.f_276668_, (Object)new Tuple(FloweraryBlocks.PITCHER_PLANT_PLANTS, FloweraryBlocks.IMPALA_LILY_PLANTS));
    });
    private final FloweraryColor primaryColor;
    private final FloweraryColor secondaryColor;

    public PollenJarItem(FloweraryColor primaryColor, FloweraryColor secondaryColor, Item.Properties properties) {
        super(properties);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Map<String, RegistryObject<Block>> plants;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Block block = world.m_8055_(pos).m_60734_();
        boolean hybrid = world.m_213780_().m_188501_() <= 0.2f;
        Tuple emptyTuple = new Tuple(Collections.emptyMap(), Collections.emptyMap());
        Map<String, Object> map = plants = hybrid ? (Map<String, RegistryObject<Block>>)((Tuple)PLANTS_BY_BLOCK.getOrDefault((Object)block, (Object)emptyTuple)).m_14419_() : (Map)((Tuple)PLANTS_BY_BLOCK.getOrDefault((Object)block, (Object)emptyTuple)).m_14418_();
        if (block.equals(Blocks.f_50357_) && hybrid && world.m_213780_().m_188499_()) {
            plants = FloweraryBlocks.ROSE_PLANTS;
        }
        if (!plants.isEmpty() && context.m_43723_() != null) {
            Player player = context.m_43723_();
            String color = this.primaryColor.m_7912_();
            if (world.m_213780_().m_188501_() <= 0.1f) {
                color = this.secondaryColor.m_7912_();
            }
            if (world.m_213780_().m_188501_() <= 0.02f) {
                color = FloweraryColor.MULTICOLOR.m_7912_();
            }
            Block crop = (Block)plants.get(color).get();
            world.m_5594_(player, pos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                ItemStack jar = context.m_43722_();
                ItemStack seeds = crop.m_5456_().m_7968_();
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    jar.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(seeds)) {
                    player.m_36176_(seeds, false);
                }
            }
            double d0 = 1.03125;
            for (int i = 0; i < 10; ++i) {
                double d3 = player.m_217043_().m_188583_() * 0.02;
                double d4 = player.m_217043_().m_188583_() * 0.02;
                double d5 = player.m_217043_().m_188583_() * 0.02;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123749_, (double)pos.m_123341_() + (double)0.13125f + (double)0.7375f * (double)player.m_217043_().m_188501_(), (double)pos.m_123342_() + d0 + (double)player.m_217043_().m_188501_() * (1.0 - d0), (double)pos.m_123343_() + (double)0.13125f + (double)0.7375f * (double)player.m_217043_().m_188501_(), d3, d4, d5);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.full_pollen_jar.desc"));
    }
}

