/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.data;

import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u0005J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0018\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0018\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00190\u0019 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lfyi/sugar/mobstoeggs/data/GetEntityFileData;", "", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "entityType", "", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;Ljava/lang/String;)V", "entity", "isEntityEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "entityName", "entityItemCost", "entityMoneyCost", "", "Ljava/lang/Double;", "entityCatchChance", "entityEggName", "entityEggLore", "", "", "entityEggCustomModelData", "entityEggCustomModelDataFloats", "", "getEntityEnabled", "getEntityName", "getEntityItemCost", "getEntityMoneyCost", "getEntityCatchChance", "getEntityEggMaterial", "getEntityEggName", "getEntityEggLore", "getEntityEggCustomModelData", "getEntityEggCustomModelDataFloats", "MobsToEggsX"})
public final class GetEntityFileData {
    @NotNull
    private final MobsToEggs plugin;
    @NotNull
    private final String entityType;
    @NotNull
    private final String entity;
    private final Boolean isEntityEnabled;
    private final String entityName;
    private final String entityItemCost;
    private final Double entityMoneyCost;
    private final Double entityCatchChance;
    private final String entityEggName;
    private final List<String> entityEggLore;
    private final List<String> entityEggCustomModelData;
    private final List<Float> entityEggCustomModelDataFloats;

    public GetEntityFileData(@NotNull MobsToEggs plugin, @NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        this.plugin = plugin;
        this.entityType = entityType;
        String string = this.entityType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.entity = string;
        this.isEntityEnabled = this.plugin.getConfigManager().getFileMobs().getBoolean(this.entity + ".entity.enabled", (Boolean)true);
        this.entityName = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".entity.entity-name", this.entity);
        this.entityItemCost = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".entity.item-cost", "Diamond-1");
        this.entityMoneyCost = this.plugin.getConfigManager().getFileMobs().getDouble(this.entity + ".entity.money-cost", (Double)10.0);
        this.entityCatchChance = this.plugin.getConfigManager().getFileMobs().getDouble(this.entity + ".entity.catch-chance", (Double)30.0);
        this.entityEggName = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".egg.egg-data.name", "");
        this.entityEggLore = this.plugin.getConfigManager().getFileMobs().getStringList(this.entity + ".egg.egg-data.lore", (List<String>)CollectionsKt.listOf((Object)""));
        this.entityEggCustomModelData = this.plugin.getConfigManager().getFileMobs().getStringList(this.entity + ".egg.egg-data.custommodeldata.strings", (List<String>)CollectionsKt.listOf((Object)""));
        this.entityEggCustomModelDataFloats = this.plugin.getConfigManager().getFileMobs().getFloatList(this.entity + ".egg.egg-data.custommodeldata.floats", (List<Float>)CollectionsKt.emptyList());
    }

    public final boolean getEntityEnabled() {
        Boolean bl = this.isEntityEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isEntityEnabled");
        return bl;
    }

    @NotNull
    public final String getEntityName() {
        String string = this.entityName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entityName");
        return string;
    }

    @NotNull
    public final String getEntityItemCost() {
        String string = this.entityItemCost;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entityItemCost");
        return string;
    }

    public final double getEntityMoneyCost() {
        Double d = this.entityMoneyCost;
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"entityMoneyCost");
        return ((Number)d).doubleValue();
    }

    public final double getEntityCatchChance() {
        Double d = this.entityCatchChance;
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"entityCatchChance");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final String getEntityEggMaterial() {
        String entityEggMaterial = null;
        if (this.plugin.getUsingMythicMobs()) {
            String string;
            MythicMob mythicMob = MythicBukkit.inst().getMobManager().getMythicMob(this.entityType).orElse(null);
            if (mythicMob != null) {
                String string2 = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".egg.egg-data.material", "PIG_SPAWN_EGG");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = string2.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                String string4 = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".egg.egg-data.material", this.entity + "_SPAWN_EGG");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                String string5 = string4.toUpperCase(Locale.ROOT);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            }
            entityEggMaterial = string;
        } else {
            String string = this.plugin.getConfigManager().getFileMobs().getString(this.entity + ".egg.egg-data.material", this.entity + "_SPAWN_EGG");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string6 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            entityEggMaterial = string6;
        }
        return entityEggMaterial;
    }

    @NotNull
    public final String getEntityEggName() {
        String string = this.entityEggName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entityEggName");
        return string;
    }

    @NotNull
    public final List<String> getEntityEggLore() {
        List<String> list = this.entityEggLore;
        Intrinsics.checkNotNullExpressionValue(list, (String)"entityEggLore");
        return list;
    }

    @NotNull
    public final List<String> getEntityEggCustomModelData() {
        List<String> list = this.entityEggCustomModelData;
        Intrinsics.checkNotNullExpressionValue(list, (String)"entityEggCustomModelData");
        return list;
    }

    @NotNull
    public final List<Float> getEntityEggCustomModelDataFloats() {
        List<Float> list = this.entityEggCustomModelDataFloats;
        Intrinsics.checkNotNullExpressionValue(list, (String)"entityEggCustomModelDataFloats");
        return list;
    }
}

