/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.libs.boostedyaml.updater;

import fyi.sugar.mobstoeggs.libs.boostedyaml.block.implementation.Section;
import fyi.sugar.mobstoeggs.libs.boostedyaml.dvs.Version;
import fyi.sugar.mobstoeggs.libs.boostedyaml.dvs.versioning.Versioning;
import fyi.sugar.mobstoeggs.libs.boostedyaml.route.Route;
import fyi.sugar.mobstoeggs.libs.boostedyaml.settings.updater.UpdaterSettings;
import fyi.sugar.mobstoeggs.libs.boostedyaml.updater.operators.Mapper;
import fyi.sugar.mobstoeggs.libs.boostedyaml.updater.operators.Relocator;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import java.util.Objects;

public class VersionedOperations {
    public static boolean run(@NotNull Section document, @NotNull Section defaults, @NotNull UpdaterSettings settings, char separator) {
        int compared;
        Versioning versioning = settings.getVersioning();
        if (versioning == null) {
            return false;
        }
        Version documentVersion = versioning.getDocumentVersion(document, false);
        Version defaultsVersion = Objects.requireNonNull(versioning.getDocumentVersion(defaults, true), "Version ID of the defaults cannot be null! Is it malformed or not specified?");
        int n = compared = documentVersion != null ? documentVersion.compareTo(defaultsVersion) : -1;
        if (compared > 0 && !settings.isEnableDowngrading()) {
            throw new UnsupportedOperationException(String.format("Downgrading is not enabled (%s > %s)!", defaultsVersion.asID(), documentVersion.asID()));
        }
        if (compared == 0) {
            return true;
        }
        if (compared < 0) {
            VersionedOperations.iterate(document, documentVersion != null ? documentVersion : versioning.getFirstVersion(), defaultsVersion, settings, separator);
        }
        settings.getIgnoredRoutes(defaultsVersion.asID(), separator).forEach(route -> document.getOptionalBlock((Route)route).ifPresent(block -> block.setIgnored(true)));
        return false;
    }

    private static void iterate(@NotNull Section document, @NotNull Version documentVersion, @NotNull Version defaultsVersion, @NotNull UpdaterSettings settings, char separator) {
        Version current = documentVersion.copy();
        while (current.compareTo(defaultsVersion) <= 0) {
            current.next();
            Relocator.apply(document, settings.getRelocations(current.asID(), separator));
            Mapper.apply(document, settings.getMappers(current.asID(), separator));
            settings.getCustomLogic(current.asID()).forEach(consumer -> consumer.accept(document.getRoot()));
        }
    }
}

