/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.data;

import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.data.GetEntityFileData;
import fyi.sugar.mobstoeggs.data.GetEntityType;
import fyi.sugar.mobstoeggs.data.ThrownCapsuleIdentityManager;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.persistence.PersistentDataContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfyi/sugar/mobstoeggs/data/ValidateCapsuleCollidingEntity;", "", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "hitEntity", "Lorg/bukkit/entity/Entity;", "capsuleEntity", "catchTypeThrow", "", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;Lorg/bukkit/entity/Entity;Lorg/bukkit/entity/Entity;Z)V", "validateCapsuleCollisionWithEntity", "MobsToEggsX"})
public final class ValidateCapsuleCollidingEntity {
    @NotNull
    private final MobsToEggs plugin;
    @NotNull
    private final Entity hitEntity;
    @NotNull
    private final Entity capsuleEntity;
    private final boolean catchTypeThrow;

    public ValidateCapsuleCollidingEntity(@NotNull MobsToEggs plugin, @NotNull Entity hitEntity, @NotNull Entity capsuleEntity, boolean catchTypeThrow) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)hitEntity, (String)"hitEntity");
        Intrinsics.checkNotNullParameter((Object)capsuleEntity, (String)"capsuleEntity");
        this.plugin = plugin;
        this.hitEntity = hitEntity;
        this.capsuleEntity = capsuleEntity;
        this.catchTypeThrow = catchTypeThrow;
    }

    public final boolean validateCapsuleCollisionWithEntity() {
        if (this.hitEntity instanceof HumanEntity) {
            return false;
        }
        if (!(this.hitEntity instanceof LivingEntity)) {
            return false;
        }
        if (this.hitEntity instanceof ArmorStand) {
            return false;
        }
        if (this.catchTypeThrow) {
            if (!(this.capsuleEntity instanceof Projectile)) {
                return false;
            }
            if (!(((Projectile)this.capsuleEntity).getShooter() instanceof Player)) {
                return false;
            }
            PersistentDataContainer persistentDataContainer = ((Projectile)this.capsuleEntity).getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
            if (!new ThrownCapsuleIdentityManager(this.plugin, persistentDataContainer).getCapsuleIdentity()) {
                return false;
            }
        }
        if (!this.catchTypeThrow && !(this.capsuleEntity instanceof Player)) {
            return false;
        }
        return new GetEntityFileData(this.plugin, new GetEntityType(this.plugin, this.hitEntity).getEntityType()).getEntityEnabled();
    }
}

