/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.events;

import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.data.CapsuleData;
import fyi.sugar.mobstoeggs.data.GetLanguageData;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfyi/sugar/mobstoeggs/events/CapsuleCreateEvent;", "", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "amount", "", "targetPlayer", "Lorg/bukkit/entity/Player;", "dropOnGround", "", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;ILorg/bukkit/entity/Player;Z)V", "onCapsuleCreate", "", "MobsToEggsX"})
public final class CapsuleCreateEvent {
    @NotNull
    private final MobsToEggs plugin;
    private final int amount;
    @NotNull
    private final Player targetPlayer;
    private final boolean dropOnGround;

    public CapsuleCreateEvent(@NotNull MobsToEggs plugin, int amount, @NotNull Player targetPlayer, boolean dropOnGround) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)targetPlayer, (String)"targetPlayer");
        this.plugin = plugin;
        this.amount = amount;
        this.targetPlayer = targetPlayer;
        this.dropOnGround = dropOnGround;
    }

    public final void onCapsuleCreate() {
        ItemStack capsuleMaterial = new CapsuleData(this.plugin).setCapsuleData();
        capsuleMaterial.setAmount(this.amount);
        if (!this.dropOnGround) {
            ItemStack[] itemStackArray = new ItemStack[]{capsuleMaterial};
            HashMap hashMap = this.targetPlayer.getInventory().addItem(itemStackArray);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"addItem(...)");
            HashMap capsulesToDrop = hashMap;
            for (Object v : capsulesToDrop.values()) {
                Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
                ItemStack item = (ItemStack)v;
                this.targetPlayer.getWorld().dropItemNaturally(this.targetPlayer.getLocation(), item);
            }
            this.targetPlayer.sendMessage(new GetLanguageData(this.plugin).getCatchCapsuleCreated(this.amount));
        } else {
            Item item = this.targetPlayer.getWorld().dropItemNaturally(this.targetPlayer.getLocation(), capsuleMaterial);
            Intrinsics.checkNotNull((Object)item);
        }
    }
}

