/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.events;

import com.palmergames.bukkit.towny.utils.CombatUtil;
import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.api.CatchCapsuleHitEntityEvent;
import fyi.sugar.mobstoeggs.data.GetConfigValue;
import fyi.sugar.mobstoeggs.data.GetEntityFileData;
import fyi.sugar.mobstoeggs.data.GetEntityType;
import fyi.sugar.mobstoeggs.data.GetLanguageData;
import fyi.sugar.mobstoeggs.data.ValidateCapsuleCollidingEntity;
import fyi.sugar.mobstoeggs.events.CapsuleItemCheckEvent;
import fyi.sugar.mobstoeggs.events.CaptureOutcomeEvent;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfyi/sugar/mobstoeggs/events/CapsuleCollisionEvent;", "Lorg/bukkit/event/Listener;", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;)V", "onCapsuleHitEvent", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onCapsuleProjectileHitEvent", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "MobsToEggsX"})
public final class CapsuleCollisionEvent
implements Listener {
    @NotNull
    private final MobsToEggs plugin;

    public CapsuleCollisionEvent(@NotNull MobsToEggs plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public final void onCapsuleHitEvent(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getDamager();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDamager(...)");
        Entity damager = entity;
        Entity entity2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
        Entity hitEntity = entity2;
        EntityDamageEvent.DamageCause causeProjectile = EntityDamageEvent.DamageCause.PROJECTILE;
        EntityDamageEvent.DamageCause causeEntityAttack = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
        if (event.getCause() == causeProjectile) {
            if (!new ValidateCapsuleCollidingEntity(this.plugin, hitEntity, damager, true).validateCapsuleCollisionWithEntity()) {
                return;
            }
            if (hitEntity instanceof Enderman) {
                return;
            }
            if (!new GetConfigValue(this.plugin).getCatchMethodThrow()) {
                return;
            }
            ProjectileSource projectileSource = ((Projectile)damager).getShooter();
            Intrinsics.checkNotNull((Object)projectileSource, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            damager = (Entity)((Player)projectileSource);
        } else if (event.getCause() == causeEntityAttack) {
            if (!new ValidateCapsuleCollidingEntity(this.plugin, hitEntity, damager, false).validateCapsuleCollisionWithEntity()) {
                return;
            }
            if (!new GetConfigValue(this.plugin).getCatchMethodPunch()) {
                return;
            }
            Player cfr_ignored_0 = (Player)damager;
            ItemStack theCapsule = new ItemStack(Material.valueOf((String)new GetConfigValue(this.plugin).getCapsuleProjectileType()));
            ItemStack itemStack = ((Player)damager).getInventory().getItemInMainHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
            ItemStack itemCapsule = itemStack;
            if (!new CapsuleItemCheckEvent(this.plugin, itemCapsule).onCapsuleItemCheck()) {
                return;
            }
            if (((Player)damager).getInventory().getItemInMainHand().getType() == theCapsule.getType()) {
                ((Player)damager).getInventory().getItemInMainHand().setAmount(itemCapsule.getAmount() - 1);
            } else if (((Player)damager).getInventory().getItemInOffHand().getType() == theCapsule.getType()) {
                ItemStack itemStack2 = ((Player)damager).getInventory().getItemInOffHand();
                itemStack2.setAmount(itemStack2.getAmount() - 1);
            }
        } else {
            return;
        }
        if (this.plugin.getUsingTowny()) {
            if (CombatUtil.preventDamageCall((Entity)damager, (Entity)hitEntity, (EntityDamageEvent.DamageCause)causeProjectile)) {
                return;
            }
            if (CombatUtil.preventDamageCall((Entity)damager, (Entity)hitEntity, (EntityDamageEvent.DamageCause)causeEntityAttack)) {
                return;
            }
        }
        if (new GetConfigValue(this.plugin).getGlobalValuesUsePermissions()) {
            GetEntityFileData getEntityFile = new GetEntityFileData(this.plugin, new GetEntityType(this.plugin, hitEntity).getEntityType());
            StringBuilder stringBuilder = new StringBuilder().append("mobstoeggs.catch.");
            String string = new GetEntityType(this.plugin, hitEntity).getEntityType().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!damager.hasPermission(stringBuilder.append(string).toString())) {
                damager.sendMessage(new GetLanguageData(this.plugin).getCatchFailNoPermission(getEntityFile.getEntityName()));
                return;
            }
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new CatchCapsuleHitEntityEvent());
        new CaptureOutcomeEvent(this.plugin, hitEntity, (Player)damager).onOutcome();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onCapsuleProjectileHitEvent(@NotNull ProjectileHitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity hitEntity = event.getHitEntity();
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)projectile, (String)"getEntity(...)");
        Projectile capsule = projectile;
        if (hitEntity == null) {
            return;
        }
        if (!(hitEntity instanceof Enderman)) {
            return;
        }
        if (!new ValidateCapsuleCollidingEntity(this.plugin, hitEntity, (Entity)capsule, true).validateCapsuleCollisionWithEntity()) {
            return;
        }
        if (new GetConfigValue(this.plugin).getCatchMethodThrow()) {
            ProjectileSource projectileSource = capsule.getShooter();
            Intrinsics.checkNotNull((Object)projectileSource, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Player playerTarget = (Player)projectileSource;
            if (new GetConfigValue(this.plugin).getGlobalValuesUsePermissions()) {
                GetEntityFileData getEntityFile = new GetEntityFileData(this.plugin, new GetEntityType(this.plugin, hitEntity).getEntityType());
                StringBuilder stringBuilder = new StringBuilder().append("mobstoeggs.catch.");
                String string = new GetEntityType(this.plugin, hitEntity).getEntityType().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (!playerTarget.hasPermission(stringBuilder.append(string).toString())) {
                    playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailNoPermission(getEntityFile.getEntityName()));
                    return;
                }
            }
            new CaptureOutcomeEvent(this.plugin, hitEntity, playerTarget).onOutcome();
        }
    }
}

