/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.events;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.data.GetConfigValue;
import fyi.sugar.mobstoeggs.data.GetEntityFileData;
import fyi.sugar.mobstoeggs.data.GetEntityType;
import fyi.sugar.mobstoeggs.data.GetLanguageData;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfyi/sugar/mobstoeggs/events/CaptureChallengeEvent;", "", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "entityHit", "Lorg/bukkit/entity/Entity;", "playerTarget", "Lorg/bukkit/entity/Player;", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;Lorg/bukkit/entity/Entity;Lorg/bukkit/entity/Player;)V", "getEntityFile", "Lfyi/sugar/mobstoeggs/data/GetEntityFileData;", "onChallenge", "", "MobsToEggsX"})
@SourceDebugExtension(value={"SMAP\nCaptureChallengeEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureChallengeEvent.kt\nfyi/sugar/mobstoeggs/events/CaptureChallengeEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1869#2,2:254\n1869#2,2:256\n*S KotlinDebug\n*F\n+ 1 CaptureChallengeEvent.kt\nfyi/sugar/mobstoeggs/events/CaptureChallengeEvent\n*L\n145#1:254,2\n154#1:256,2\n*E\n"})
public final class CaptureChallengeEvent {
    @NotNull
    private final MobsToEggs plugin;
    @NotNull
    private final Entity entityHit;
    @NotNull
    private final Player playerTarget;
    @NotNull
    private final GetEntityFileData getEntityFile;

    public CaptureChallengeEvent(@NotNull MobsToEggs plugin, @NotNull Entity entityHit, @NotNull Player playerTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)entityHit, (String)"entityHit");
        Intrinsics.checkNotNullParameter((Object)playerTarget, (String)"playerTarget");
        this.plugin = plugin;
        this.entityHit = entityHit;
        this.playerTarget = playerTarget;
        this.getEntityFile = new GetEntityFileData(this.plugin, new GetEntityType(this.plugin, this.entityHit).getEntityType());
    }

    public final boolean onChallenge() {
        double moneyCost;
        String[] currentLocation;
        if (Random.Default.nextDouble(0.0, 1.0) * (double)100 > this.getEntityFile.getEntityCatchChance()) {
            if (new GetConfigValue(this.plugin).getCatchEffectsSendCatchFailGenericMessage()) {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailGeneric(this.getEntityFile.getEntityName()));
            }
            return false;
        }
        if (!new GetConfigValue(this.plugin).getCatchBabyMobs() && this.entityHit instanceof Ageable && !((Ageable)this.entityHit).isAdult()) {
            this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailBabyNotAllowed(this.getEntityFile.getEntityName()));
            return false;
        }
        if (!new GetConfigValue(this.plugin).getCatchShearedMobs() && this.entityHit instanceof Sheep && ((Sheep)this.entityHit).isSheared()) {
            this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailShearedNotAllowed(this.getEntityFile.getEntityName()));
            return false;
        }
        if (!new GetConfigValue(this.plugin).getCatchTamedMobs() && this.entityHit instanceof Tameable && ((Tameable)this.entityHit).isTamed()) {
            if (((Tameable)this.entityHit).getType() == EntityType.CAMEL) {
                if (!new GetConfigValue(this.plugin).getIgnoreCatchTamedMobsValueForCamels()) {
                    this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailTamedNotAllowed(this.getEntityFile.getEntityName()));
                    return false;
                }
            } else {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailTamedNotAllowed(this.getEntityFile.getEntityName()));
                return false;
            }
        }
        if (this.entityHit.customName() != null) {
            if (!new GetConfigValue(this.plugin).getCatchNamedMobs()) {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailNamedNotAllowed(this.getEntityFile.getEntityName()));
                return false;
            }
            if (!new GetConfigValue(this.plugin).getNamedMobsKeepName()) {
                this.entityHit.customName((Component)Component.text((String)""));
            }
        }
        boolean bl = !((Collection)new GetConfigValue(this.plugin).getWorlds()).isEmpty();
        if (bl) {
            if (new GetConfigValue(this.plugin).getCatchOnlyInListedWorlds()) {
                if (!new GetConfigValue(this.plugin).getWorlds().contains(this.playerTarget.getWorld().getName())) {
                    this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailWorldNotAllowed(this.getEntityFile.getEntityName()));
                    return false;
                }
            } else if (new GetConfigValue(this.plugin).getWorlds().contains(this.playerTarget.getWorld().getName())) {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailWorldNotAllowed(this.getEntityFile.getEntityName()));
                return false;
            }
        }
        if (this.plugin.getUsingWorldGuard()) {
            boolean bl2 = !((Collection)new GetConfigValue(this.plugin).getRegions()).isEmpty();
            if (bl2) {
                RegionContainer wgContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
                currentLocation = BukkitAdapter.adapt((Location)this.entityHit.getLocation());
                RegionQuery wgRegionManager = wgContainer.createQuery();
                ApplicableRegionSet wgRegions = wgRegionManager.getApplicableRegions((com.sk89q.worldedit.util.Location)currentLocation);
                if (wgRegionManager != null) {
                    if (new GetConfigValue(this.plugin).getCatchOnlyInListedRegions()) {
                        Set set = wgRegions.getRegions();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRegions(...)");
                        Iterable $this$forEach$iv = set;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ProtectedRegion region = (ProtectedRegion)element$iv;
                            boolean bl3 = false;
                            if (new GetConfigValue(this.plugin).getRegions().contains(region.getId())) continue;
                            this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailRegionNotAllowed(this.getEntityFile.getEntityName()));
                            return false;
                        }
                    } else {
                        Set set = wgRegions.getRegions();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRegions(...)");
                        Iterable $this$forEach$iv = set;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ProtectedRegion region = (ProtectedRegion)element$iv;
                            boolean bl4 = false;
                            if (!new GetConfigValue(this.plugin).getRegions().contains(region.getId())) continue;
                            this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailRegionNotAllowed(this.getEntityFile.getEntityName()));
                            return false;
                        }
                    }
                }
            }
        }
        if (new GetConfigValue(this.plugin).getEnableItemCost()) {
            String string = this.getEntityFile.getEntityItemCost().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String itemCost = string;
            if (((CharSequence)itemCost).length() > 0 && !StringsKt.equals((String)itemCost, (String)"none", (boolean)true)) {
                currentLocation = new String[]{"-"};
                List itemSplit = StringsKt.split$default((CharSequence)itemCost, (String[])currentLocation, (boolean)false, (int)0, (int)6, null);
                ItemStack itemType = new ItemStack(Material.valueOf((String)((String)itemSplit.get(0))));
                int itemPrice = Integer.parseInt((String)itemSplit.get(1));
                if (!this.playerTarget.getInventory().containsAtLeast(itemType, itemPrice)) {
                    GetLanguageData getLanguageData = new GetLanguageData(this.plugin);
                    String string2 = this.getEntityFile.getEntityName();
                    String string3 = itemType.getType().name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    this.playerTarget.sendMessage(getLanguageData.getCatchFailNoItem(string2, string3, itemPrice));
                    return false;
                }
                if (new GetConfigValue(this.plugin).getIgnoreCreativeCosts() && this.playerTarget.getGameMode() == GameMode.CREATIVE) {
                    return true;
                }
                itemType.setAmount(itemPrice);
                ItemStack[] itemStackArray = new ItemStack[]{itemType};
                this.playerTarget.getInventory().removeItem(itemStackArray);
                GetLanguageData getLanguageData = new GetLanguageData(this.plugin);
                String string4 = this.getEntityFile.getEntityName();
                String string5 = itemType.getType().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                this.playerTarget.sendMessage(getLanguageData.getCatchSuccessWithItem(string4, string5, itemPrice));
            }
        }
        if (new GetConfigValue(this.plugin).getEnableMoneyCost() && !((moneyCost = this.getEntityFile.getEntityMoneyCost()) == 0.0)) {
            if (this.plugin.getEconomy().getBalance((OfflinePlayer)this.playerTarget) < moneyCost) {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchFailNoMoney(this.getEntityFile.getEntityName(), moneyCost));
                return false;
            }
            if (new GetConfigValue(this.plugin).getIgnoreCreativeCosts() && this.playerTarget.getGameMode() == GameMode.CREATIVE) {
                return true;
            }
            EconomyResponse r = this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)this.playerTarget, moneyCost);
            if (r != null && r.transactionSuccess()) {
                this.playerTarget.sendMessage(new GetLanguageData(this.plugin).getCatchSuccessWithMoney(this.getEntityFile.getEntityName(), moneyCost));
            }
        }
        return true;
    }
}

