/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.utility;

import fyi.sugar.mobstoeggs.MobsToEggs;
import fyi.sugar.mobstoeggs.libs.boostedyaml.YamlDocument;
import fyi.sugar.mobstoeggs.libs.boostedyaml.dvs.versioning.BasicVersioning;
import fyi.sugar.mobstoeggs.libs.boostedyaml.settings.Settings;
import fyi.sugar.mobstoeggs.libs.boostedyaml.settings.general.GeneralSettings;
import fyi.sugar.mobstoeggs.libs.boostedyaml.settings.loader.LoaderSettings;
import fyi.sugar.mobstoeggs.libs.boostedyaml.settings.updater.UpdaterSettings;
import fyi.sugar.mobstoeggs.libs.jetbrains.NotNull;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfyi/sugar/mobstoeggs/utility/ConfigManager;", "", "plugin", "Lfyi/sugar/mobstoeggs/MobsToEggs;", "<init>", "(Lfyi/sugar/mobstoeggs/MobsToEggs;)V", "getConfig", "Lfyi/sugar/mobstoeggs/libs/boostedyaml/YamlDocument;", "kotlin.jvm.PlatformType", "getMobs", "getLoadedLanguage", "getFileConfig", "getFileMobs", "getLanguage", "setup", "", "loadLanguage", "Ljava/io/File;", "MobsToEggsX"})
public final class ConfigManager {
    @NotNull
    private final MobsToEggs plugin;
    private final YamlDocument getConfig;
    private final YamlDocument getMobs;
    private final YamlDocument getLoadedLanguage;

    public ConfigManager(@NotNull MobsToEggs plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        InputStream inputStream = this.plugin.getResource("config.yml");
        Intrinsics.checkNotNull((Object)inputStream);
        Settings[] settingsArray = new Settings[]{GeneralSettings.builder().setUseDefaults(true).build(), LoaderSettings.builder().setAutoUpdate(true).build(), UpdaterSettings.builder().setAutoSave(true).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).setVersioning(new BasicVersioning("config-version")).build()};
        this.getConfig = YamlDocument.create(file, inputStream, settingsArray);
        File file2 = new File(this.plugin.getDataFolder(), "/mobs/mobs.yml");
        InputStream inputStream2 = this.plugin.getResource("mobs/mobs.yml");
        Intrinsics.checkNotNull((Object)inputStream2);
        settingsArray = new Settings[]{GeneralSettings.builder().setUseDefaults(true).build(), LoaderSettings.builder().setAutoUpdate(true).build(), UpdaterSettings.builder().setAutoSave(true).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).setVersioning(new BasicVersioning("config-version")).build()};
        this.getMobs = YamlDocument.create(file2, inputStream2, settingsArray);
        File file3 = this.loadLanguage();
        InputStream inputStream3 = this.plugin.getResource("data/language/en.yml");
        Intrinsics.checkNotNull((Object)inputStream3);
        settingsArray = new Settings[]{GeneralSettings.builder().setUseDefaults(true).build(), LoaderSettings.builder().setAutoUpdate(true).build(), UpdaterSettings.builder().setAutoSave(true).setOptionSorting(UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS).build()};
        this.getLoadedLanguage = YamlDocument.create(file3, inputStream3, settingsArray);
    }

    @NotNull
    public final YamlDocument getFileConfig() {
        YamlDocument yamlDocument = this.getConfig;
        Intrinsics.checkNotNullExpressionValue((Object)yamlDocument, (String)"getConfig");
        return yamlDocument;
    }

    @NotNull
    public final YamlDocument getFileMobs() {
        YamlDocument yamlDocument = this.getMobs;
        Intrinsics.checkNotNullExpressionValue((Object)yamlDocument, (String)"getMobs");
        return yamlDocument;
    }

    @NotNull
    public final YamlDocument getLanguage() {
        YamlDocument yamlDocument = this.getLoadedLanguage;
        Intrinsics.checkNotNullExpressionValue((Object)yamlDocument, (String)"getLoadedLanguage");
        return yamlDocument;
    }

    public final void setup() {
        this.plugin.getLogger().info("Loading files for MobsToEggs...");
        this.getFileConfig();
        this.getFileMobs();
        this.loadLanguage();
        this.getLanguage();
    }

    private final File loadLanguage() {
        String lang = this.getFileConfig().getString("language");
        File confMsg = new File(this.plugin.getDataFolder(), "/data/language/" + lang + ".yml");
        if (!confMsg.exists()) {
            this.plugin.getLogger().info("Loading language files...");
            this.plugin.saveResource("data/language/en.yml", false);
            this.plugin.saveResource("data/language/es.yml", false);
            this.plugin.saveResource("data/language/hu.yml", false);
            this.plugin.saveResource("data/language/zh-s.yml", false);
            this.plugin.saveResource("data/language/zh-t.yml", false);
            this.plugin.saveResource("data/language/pt.yml", false);
            this.plugin.getLogger().info("Language files loaded!");
            if (!confMsg.exists()) {
                this.plugin.getLogger().severe("The language file " + lang + ".yml does not exist! If you're using a custom language file, make sure the file name is correct in the language folder and config.yml!");
                this.getFileConfig().set("language", (Object)"en");
                this.getFileConfig().save();
                this.plugin.getLogger().warning("The language file has been reset to en.yml to avoid undesired outcomes.");
            }
        }
        return confMsg;
    }
}

