/*
 * Decompiled with CFR 0.152.
 */
package net.martenhammer.engravePlugin.listeners;

import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.martenhammer.engravePlugin.EngravePlugin;
import net.martenhammer.engravePlugin.managers.ItemManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class EngraveListener
implements Listener {
    private final EngravePlugin plugin;
    private final ItemManager itemManager;

    public EngraveListener(EngravePlugin plugin) {
        this.plugin = plugin;
        this.itemManager = new ItemManager(plugin);
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        String renameText = event.getInventory().getRenameText();
        AnvilInventory anvil = event.getInventory();
        ItemStack first = anvil.getItem(0);
        ItemStack second = anvil.getItem(1);
        Player player = (Player)event.getView().getPlayer();
        if (this.isEngraver(second) && this.isGearItem(first)) {
            if (this.isEngraved(first)) {
                event.setResult(null);
                return;
            }
            ItemStack result = first.clone();
            ItemMeta meta = result.getItemMeta();
            if (meta != null) {
                String loreColor;
                ArrayList<CallSite> lore;
                ArrayList<CallSite> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                if (lore == null) {
                    lore = new ArrayList<CallSite>();
                }
                switch (loreColor = this.plugin.getConfig().getString("engraving.engraving-color", "dark-purple")) {
                    case "dark-purple": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_PURPLE) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_PURPLE) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-red": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_RED) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_RED) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-blue": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_BLUE) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_BLUE) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-green": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GREEN) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GREEN) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-gray": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-grey": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "dark-aqua": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_AQUA) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_AQUA) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "red": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "gold": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "orange": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "yellow": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "green": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "blue": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "light-blue": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "aqua": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "purple": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.LIGHT_PURPLE) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.LIGHT_PURPLE) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "white": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "black": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLACK) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLACK) + this.getDateString(player.getWorld().getFullTime()))));
                        break;
                    }
                    case "magic": {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.MAGIC) + "Forged by " + player.getName())));
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.MAGIC) + this.getDateString(player.getWorld().getFullTime()))));
                    }
                }
                meta.setLore(lore);
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(EngravePlugin.ENGRAVED_BOOLEAN_KEY, PersistentDataType.BOOLEAN, (Object)true);
                meta.setDisplayName(renameText);
                result.setItemMeta(meta);
                event.setResult(result);
                anvil.setRepairCost(1);
            }
        } else if (this.isEngraved(first)) {
            ItemMeta firstItemMeta = first.getItemMeta();
            if (firstItemMeta.hasDisplayName()) {
                String firstDisplayName = firstItemMeta.getDisplayName();
                if (event.getResult() != null && event.getResult().getItemMeta() != null) {
                    if (event.getResult().getItemMeta().getDisplayName() != firstDisplayName) {
                        event.setResult(null);
                    }
                } else {
                    event.setResult(null);
                }
            }
            if (!firstItemMeta.hasDisplayName()) {
                String firstOriginalName = firstItemMeta.getItemName();
                if (event.getResult() != null && event.getResult().getItemMeta() != null) {
                    if (event.getResult().getItemMeta().getDisplayName() != firstOriginalName) {
                        event.setResult(null);
                    }
                } else {
                    event.setResult(null);
                }
            }
        }
    }

    private boolean isEngraver(ItemStack item) {
        if (item == null || item.getType() != Material.BRICK || item.getAmount() > 1) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasCustomModelData() && meta.getCustomModelData() == 1600 && meta.hasItemName() && meta.getItemName().equals("Engraver");
    }

    private boolean isGearItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type.name().endsWith("_HELMET") || type.name().endsWith("_CHESTPLATE") || type.name().endsWith("_LEGGINGS") || type.name().endsWith("_BOOTS") || type.name().endsWith("_SWORD") || type.name().endsWith("_AXE") || type.name().endsWith("_PICKAXE") || type.name().endsWith("_SHOVEL") || type.name().endsWith("_HOE") || type == Material.BOW || type == Material.CROSSBOW || type == Material.SHIELD;
    }

    private boolean isEngraved(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(EngravePlugin.ENGRAVED_BOOLEAN_KEY, PersistentDataType.BOOLEAN);
    }

    private String getDateString(long worldTime) {
        String dateFormat = this.plugin.getConfig().getString("engraving.date-format", "real");
        long dayLength = this.plugin.getConfig().getLong("engraving.day-length", 24000L);
        long yearLength = this.plugin.getConfig().getLong("engraving.year-length", 360L);
        if (dateFormat.equalsIgnoreCase("world")) {
            long days = worldTime / dayLength;
            return "on Day " + days;
        }
        if (dateFormat.equalsIgnoreCase("days-since")) {
            long currentDay = worldTime / dayLength;
            long startDay = this.plugin.getConfig().getLong("engraving.days-since-start-day", 100L);
            long daysSince = currentDay - startDay;
            if (daysSince < 0L) {
                return "on Invalid start day";
            }
            if (daysSince > yearLength) {
                long years = daysSince / yearLength;
                if (!this.plugin.getConfig().getString("engraving.start-day").equalsIgnoreCase("Start Day")) {
                    String startDayName = this.plugin.getConfig().getString("engraving.start-day", "Start Day");
                    return years + " years and " + daysSince % yearLength + " days after " + startDayName;
                }
                return years + " years and " + daysSince % yearLength + " days after " + startDay;
            }
            if (!this.plugin.getConfig().getString("engraving.start-day").equalsIgnoreCase("Start Day")) {
                String startDayName = this.plugin.getConfig().getString("engraving.start-day", "Start Day");
                return "Day " + daysSince + " after " + startDayName;
            }
            return "Day " + daysSince + " after " + startDay;
        }
        LocalDate date = LocalDate.now();
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

