/*
 * Decompiled with CFR 0.152.
 */
package net.r3dd3st.spawncommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.server.MinecraftServer;
import net.r3dd3st.spawncommands.LocationData;
import net.r3dd3st.spawncommands.accessor.DeathLocationAccessor;
import net.r3dd3st.spawncommands.accessor.FreezeAccessor;
import net.r3dd3st.spawncommands.accessor.HomeAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnCommandsMod
implements ModInitializer {
    public static final String MOD_ID = "spawncommands";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"spawncommands");

    public void onInitialize() {
        LOGGER.info("Initializing spawn Commands mod v1.20.1x1.1.0b");
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, wasDeath) -> {
            try {
                LOGGER.info("COPY_FROM EVENT FIRED! wasDeath = {}", (Object)wasDeath);
                class_5321 dimension = oldPlayer.method_37908().method_27983();
                double x = oldPlayer.method_23317();
                double y = oldPlayer.method_23318();
                double z = oldPlayer.method_23321();
                float yaw = oldPlayer.method_36454();
                float pitch = oldPlayer.method_36455();
                LocationData deathLocation = new LocationData((class_5321<class_1937>)dimension, x, y, z, yaw, pitch);
                LOGGER.info("COPY_FROM (Death): Attempting to store death coordinates for {}: {}.", (Object)newPlayer.method_5477().getString(), (Object)deathLocation);
                DeathLocationAccessor newPlayerAccessor = (DeathLocationAccessor)newPlayer;
                newPlayerAccessor.spawncommands_setLastDeathLocation(deathLocation);
                LocationData checkLocation = newPlayerAccessor.spawncommands_getLastDeathLocation();
                LOGGER.info("COPY_FROM (death): Stored death location for {}: {}", (Object)newPlayer.method_5477().getString(), (Object)deathLocation);
            }
            catch (Exception e) {
                LOGGER.error("COPY_FROM: Error processing player data.");
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                boolean hasAntiJump;
                if (player.field_13987 == null) continue;
                FreezeAccessor accessor = (FreezeAccessor)player;
                boolean shouldBeFrozen = accessor.spawncommands_isFrozen();
                class_1293 currentSlowness = player.method_6112(class_1294.field_5909);
                boolean hasSlowness = currentSlowness != null && currentSlowness.method_5578() >= 100 && !currentSlowness.method_48557(20);
                class_1293 currentJump = player.method_6112(class_1294.field_5913);
                boolean bl = hasAntiJump = currentJump != null && currentJump.method_5578() <= -100 && !currentJump.method_48557(20);
                if (shouldBeFrozen) {
                    if (!hasSlowness) {
                        player.method_6092(new class_1293(class_1294.field_5909, -1, 127, false, false, false));
                    }
                    if (!hasAntiJump) {
                        player.method_6092(new class_1293(class_1294.field_5913, -1, -128, false, false, false));
                    }
                    player.field_6017 = 0.0f;
                    continue;
                }
                if (hasSlowness) {
                    player.method_6016(class_1294.field_5909);
                }
                if (!hasAntiJump) continue;
                player.method_6016(class_1294.field_5913);
            }
        });
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> {
            commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"hub").executes(commandContext -> {
                class_3222 player = ((class_2168)commandContext.getSource()).method_9207();
                this.teleportPlayerToSpawn(player);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleported to spawn"), false);
                return 1;
            }));
            commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"lobby").executes(commandContext -> {
                class_3222 player = ((class_2168)commandContext.getSource()).method_9207();
                this.teleportPlayerToSpawn(player);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleported to spawn"), false);
                return 1;
            }));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(source -> source.method_9259(0))).executes(context -> {
                LOGGER.info("--- Executing /sethome command logic ---");
                try {
                    class_3222 player = ((class_2168)context.getSource()).method_9207();
                    if (!(player instanceof HomeAccessor)) {
                        LOGGER.error("FATAL: Player {} does not implement HomeAccessor! Mixin failed to apply?", (Object)player.method_5477().getString());
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Internal Error: Player data setup failed (HA). Check logs."));
                        return 0;
                    }
                    HomeAccessor accessor = (HomeAccessor)player;
                    LocationData homeLocation = new LocationData((class_5321<class_1937>)player.method_37908().method_27983(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
                    if (homeLocation == null) {
                        LOGGER.error("FATAL: Failed to create homeLocation data for {}", (Object)player.method_5477().getString());
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Internal Error: Location data creation failed. Check logs."));
                        return 0;
                    }
                    accessor.spawncommands_setHome(homeLocation);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Home set!"), false);
                    return 1;
                }
                catch (Throwable t) {
                    LOGGER.error("!!! Caught Throwable in /sethome for " + ((class_2168)context.getSource()).method_9214());
                    System.err.println("!!! Stack trace for /sethome error:");
                    t.printStackTrace(System.err);
                    LOGGER.error("Full /sethome error details: ", t);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error setting home! Check console/logs (stack trace printed)."));
                    return 0;
                }
            }));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(serverCommandSource -> serverCommandSource.method_9259(0))).executes(context -> {
                LOGGER.info("--- EXECUTING /sethome COMMAND ---");
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                HomeAccessor accessor = (HomeAccessor)player;
                LocationData homeLocation = accessor.spawncommands_getHome();
                if (homeLocation != null) {
                    MinecraftServer server = player.method_5682();
                    if (server == null) {
                        return 0;
                    }
                    class_3218 targetWorld = server.method_3847(homeLocation.dimension());
                    if (targetWorld != null) {
                        player.method_14251(targetWorld, homeLocation.x(), homeLocation.y(), homeLocation.z(), homeLocation.yaw(), homeLocation.pitch());
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleporting home..."), false);
                        return 1;
                    }
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error: Your home dimension could not be loaded!"));
                    return 0;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You have not set a home! Use /sethome"));
                return 0;
            }));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(serverCommandSource -> serverCommandSource.method_9259(0))).executes(commandContext -> {
                class_3222 player = ((class_2168)commandContext.getSource()).method_9207();
                MinecraftServer server = player.method_5682();
                DeathLocationAccessor playerAccessor = (DeathLocationAccessor)player;
                LocationData deathLocation = playerAccessor.spawncommands_getLastDeathLocation();
                if (deathLocation != null) {
                    if (server == null) {
                        return 0;
                    }
                    class_3218 targetWorld = server.method_3847(deathLocation.dimension());
                    if (targetWorld != null) {
                        player.method_14251(targetWorld, deathLocation.x(), deathLocation.y(), deathLocation.z(), deathLocation.yaw(), deathLocation.pitch());
                        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleported to your last death."), false);
                        playerAccessor.spawncommands_setLastDeathLocation(null);
                        return 1;
                    }
                    ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error: The dimension you died in could not be found or loaded."));
                    LOGGER.warn("Player {} could not use /back (NBT) because dimension {} could not be loaded.", (Object)player.method_5477().getString(), (Object)deathLocation.dimension().method_29177());
                    return 0;
                }
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)"No death location saved."), false);
                return 0;
            }));
            int requiredPermissionLevel = 2;
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"freeze").requires(serverCommandSource -> serverCommandSource.method_9259(requiredPermissionLevel))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(commandContext -> {
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)commandContext, (String)"player");
                FreezeAccessor accessor = (FreezeAccessor)targetPlayer;
                if (accessor.spawncommands_isFrozen()) {
                    ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)(targetPlayer.method_5477().getString() + "is already frozen. Did you mean /unfreeze?")));
                    return 0;
                }
                accessor.spawncommands_setFrozen(true);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("Froze player " + targetPlayer.method_5477().getString())), true);
                targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"You have been frozen. This is most likely due to breach of the server's rules."));
                targetPlayer.method_6092(new class_1293(class_1294.field_5909, -1, 127, false, false, false));
                targetPlayer.method_6092(new class_1293(class_1294.field_5913, -1, -128, false, false, false));
                class_5250 titleText = class_2561.method_43470((String)"You have been frozen").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)));
                class_5905 timingsPacket = new class_5905(10, 70, 20);
                class_5904 titlePacket = new class_5904((class_2561)titleText);
                targetPlayer.field_13987.method_14364((class_2596)timingsPacket);
                targetPlayer.field_13987.method_14364((class_2596)titlePacket);
                return 1;
            })));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cuff").requires(serverCommandSource -> serverCommandSource.method_9259(requiredPermissionLevel))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(commandContext -> {
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)commandContext, (String)"player");
                FreezeAccessor accessor = (FreezeAccessor)targetPlayer;
                if (accessor.spawncommands_isFrozen()) {
                    ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)(targetPlayer.method_5477().getString() + "is already cuffed. Did you mean /unfreeze?")));
                    return 0;
                }
                accessor.spawncommands_setFrozen(true);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("Cuffed (Jailed) player " + targetPlayer.method_5477().getString())), true);
                targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"You have been cuffed. (Jailed) This is most likely due to breach of the server's rules."));
                targetPlayer.method_6092(new class_1293(class_1294.field_5909, -1, 127, false, false, false));
                targetPlayer.method_6092(new class_1293(class_1294.field_5913, -1, -128, false, false, false));
                class_5250 titleText = class_2561.method_43470((String)"You have been frozen").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)));
                class_5905 timingsPacket = new class_5905(10, 70, 20);
                class_5904 titlePacket = new class_5904((class_2561)titleText);
                targetPlayer.field_13987.method_14364((class_2596)timingsPacket);
                targetPlayer.field_13987.method_14364((class_2596)titlePacket);
                return 1;
            })));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unfreeze").requires(serverCommandSource -> serverCommandSource.method_9259(requiredPermissionLevel))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(commandContext -> {
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)commandContext, (String)"player");
                FreezeAccessor accessor = (FreezeAccessor)targetPlayer;
                if (!accessor.spawncommands_isFrozen()) {
                    ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)(targetPlayer.method_5477().getString() + " is not frozen.")));
                    return 0;
                }
                accessor.spawncommands_setFrozen(false);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("Unfroze player " + targetPlayer.method_5477().getString())), true);
                targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"You have been unfrozen!"));
                targetPlayer.method_6016(class_1294.field_5909);
                targetPlayer.method_6016(class_1294.field_5913);
                return 1;
            })));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"uncuff").requires(source -> source.method_9259(requiredPermissionLevel))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(commandContext -> {
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)commandContext, (String)"player");
                FreezeAccessor accessor = (FreezeAccessor)targetPlayer;
                if (!accessor.spawncommands_isFrozen()) {
                    ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)(targetPlayer.method_5477().getString() + " is not cuffed/frozen.")));
                    return 0;
                }
                accessor.spawncommands_setFrozen(false);
                ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("Uncuffed player " + targetPlayer.method_5477().getString())), true);
                targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"You have been uncuffed!"));
                targetPlayer.method_6016(class_1294.field_5909);
                targetPlayer.method_6016(class_1294.field_5913);
                return 1;
            })));
        });
    }

    private void teleportPlayerToSpawn(class_3222 player) {
        class_3218 world = player.method_51469();
        class_2338 spawnPos = world.method_43126();
        float spawnAngle = world.method_43127();
        player.method_14251(world, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, spawnAngle, 0.0f);
        LOGGER.info("Player {} teleported to spawn at {}, {}, {}", new Object[]{player.method_5477().getString(), spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()});
    }
}

