/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.currency;

import info.preva1l.fadah.currency.Currency;
import info.preva1l.fadah.currency.CurrencyBase;
import info.preva1l.fadah.currency.MultiCurrency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CurrencyRegistry {
    private static final Logger LOGGER = Logger.getLogger("Fadah");
    private static final Map<String, Currency> currencies = new ConcurrentHashMap<String, Currency>();
    private static final List<String> orderedIds = Collections.synchronizedList(new ArrayList());

    private CurrencyRegistry() {
        throw new UnsupportedOperationException("Registries cannot be instantiated.");
    }

    @Deprecated(since="3.0.0")
    public static void registerMulti(@NotNull MultiCurrency currency) {
        CurrencyRegistry.register(currency);
    }

    public static void register(@NotNull CurrencyBase currencyBase) {
        Plugin requiredPlugin;
        Objects.requireNonNull(currencyBase, "Currency base cannot be null");
        String currencyId = currencyBase.getId().toLowerCase();
        if (currencies.containsKey(currencyId)) {
            throw new IllegalArgumentException("Currency with the id '" + currencyId + "' is already registered!");
        }
        if (!(currencyBase.getRequiredPlugin().isEmpty() || (requiredPlugin = Bukkit.getPluginManager().getPlugin(currencyBase.getRequiredPlugin())) != null && requiredPlugin.isEnabled())) {
            if (currencyBase.isEnabled()) {
                LOGGER.warning("[Services] [CurrencyService] Required plugin '" + currencyBase.getRequiredPlugin() + "' not found or disabled for currency: " + currencyId);
            }
            return;
        }
        if (!currencyBase.preloadChecks()) {
            LOGGER.severe("[Services] [CurrencyService] Preload checks failed for currency: " + currencyId);
            return;
        }
        if (currencyBase instanceof MultiCurrency) {
            MultiCurrency multiCurrency = (MultiCurrency)currencyBase;
            CurrencyRegistry.registerMultiCurrencyInternal(multiCurrency);
            return;
        }
        if (currencyBase instanceof Currency) {
            Currency currency = (Currency)currencyBase;
            CurrencyRegistry.registerSingleCurrency(currency);
        } else {
            LOGGER.warning("[Services] [CurrencyService] Unknown CurrencyBase implementation: " + currencyBase.getClass().getSimpleName());
        }
    }

    private static void registerMultiCurrencyInternal(@NotNull MultiCurrency multiCurrency) {
        List<Currency> subCurrencies = multiCurrency.getCurrencies();
        if (subCurrencies == null || subCurrencies.isEmpty()) {
            LOGGER.warning("[Services] [CurrencyService] MultiCurrency '" + multiCurrency.getId() + "' has no sub-currencies");
            return;
        }
        for (Currency currency : subCurrencies) {
            if (currency == null) continue;
            CurrencyRegistry.registerSingleCurrency(currency);
        }
    }

    private static void registerSingleCurrency(@NotNull Currency currency) {
        String currencyId = currency.getId().toLowerCase();
        currencies.put(currencyId, currency);
        orderedIds.add(currencyId);
        LOGGER.info("[Services] [CurrencyService] Registered: " + currency.getId());
    }

    @Nullable
    public static Currency get(@NotNull String currencyId) {
        Objects.requireNonNull(currencyId, "Currency ID cannot be null");
        Currency currency = currencies.get(currencyId.toLowerCase());
        return currency != null && currency.isEnabled() ? currency : null;
    }

    public static void unregister(@NotNull Currency currency) {
        Objects.requireNonNull(currency, "Currency cannot be null");
        String currencyId = currency.getId().toLowerCase();
        Currency removed = currencies.remove(currencyId);
        if (removed != null) {
            orderedIds.remove(currencyId);
            LOGGER.info("[Services] [CurrencyService] Unregistered: " + currency.getId());
        }
    }

    @Nullable
    public static Currency getNext(@NotNull Currency current) {
        return CurrencyRegistry.getAdjacent(current, 1);
    }

    @Nullable
    public static Currency getPrevious(@NotNull Currency current) {
        return CurrencyRegistry.getAdjacent(current, -1);
    }

    @Nullable
    private static Currency getAdjacent(@NotNull Currency current, int direction) {
        int nextIndex;
        Objects.requireNonNull(current, "Current currency cannot be null");
        String currentId = current.getId().toLowerCase();
        ArrayList<String> snapshot = new ArrayList<String>(orderedIds);
        int currentIndex = snapshot.indexOf(currentId);
        if (currentIndex == -1) {
            return null;
        }
        int size = snapshot.size();
        for (int i = 1; i < size && (nextIndex = currentIndex + direction * i) >= 0 && nextIndex < size; ++i) {
            String nextId = (String)snapshot.get(nextIndex);
            Currency nextCurrency = currencies.get(nextId);
            if (nextCurrency == null || !nextCurrency.isEnabled()) continue;
            return nextCurrency;
        }
        return null;
    }

    @NotNull
    public static List<Currency> getAll() {
        return orderedIds.stream().map(currencies::get).filter(Objects::nonNull).filter(CurrencyBase::isEnabled).toList();
    }
}

