/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.records.collection;

import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public record CollectableItem(ItemStack itemStack, long dateAdded) implements Comparable<CollectableItem>
{
    public static CollectableItem of(@NotNull ItemStack itemStack) {
        return new CollectableItem(itemStack, System.currentTimeMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        long l;
        ItemStack stack;
        if (!(o instanceof CollectableItem)) return false;
        CollectableItem collectableItem = (CollectableItem)o;
        try {
            ItemStack itemStack;
            stack = itemStack = collectableItem.itemStack();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        long added = l = collectableItem.dateAdded();
        if (added != this.dateAdded()) return false;
        if (!stack.equals((Object)this.itemStack)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.itemStack, this.dateAdded);
    }

    @Override
    public int compareTo(@NotNull CollectableItem o) {
        return Long.compare(o.dateAdded, this.dateAdded);
    }
}

