/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.records.history;

import com.google.gson.annotations.Expose;
import info.preva1l.fadah.api.AuctionHouseAPI;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record HistoricItem(@Expose @NotNull Long loggedDate, @Expose @NotNull LoggedAction action, @Expose @NotNull ItemStack itemStack, @Expose @Nullable Double price, @Expose @Nullable UUID playerUUID, @Expose @Nullable Boolean biddable, @Expose @Nullable Double starting) implements Comparable<HistoricItem>
{
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Long date;
        Object object;
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoricItem)) return false;
        HistoricItem historicItem = (HistoricItem)o;
        try {
            date = object = historicItem.loggedDate();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object action1 = object = historicItem.action();
        Object stack = object = historicItem.itemStack();
        Object price1 = object = historicItem.price();
        Object buyerUid = object = historicItem.playerUUID();
        Object biddable1 = object = historicItem.biddable();
        Object starting2 = object = historicItem.starting();
        if (!Objects.equals(this.price, price1)) return false;
        if (!Objects.equals(this.loggedDate, date)) return false;
        if (!Objects.equals(this.playerUUID, buyerUid)) return false;
        if (this.action != action1) return false;
        if (!Objects.equals(this.itemStack, stack)) return false;
        if (!Objects.equals(this.biddable, biddable1)) return false;
        if (!Objects.equals(this.starting, starting2)) return false;
        return true;
    }

    @Override
    public int compareTo(@NotNull HistoricItem o) {
        return Long.compare(o.loggedDate, this.loggedDate);
    }

    public static enum LoggedAction {
        LISTING_START,
        LISTING_PURCHASED,
        LISTING_SOLD,
        LISTING_CANCEL,
        LISTING_EXPIRE,
        LISTING_ADMIN_CANCEL,
        EXPIRED_ITEM_CLAIM,
        EXPIRED_ITEM_ADMIN_CLAIM,
        COLLECTION_BOX_CLAIM,
        COLLECTION_BOX_ADMIN_CLAIM,
        LISTING_BID_RECEIVED,
        LISTING_BID_PLACED;


        public String getLocaleActionName() {
            return AuctionHouseAPI.getInstance().getLoggedActionLocale(this);
        }
    }
}

