/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.records.listing;

import info.preva1l.fadah.currency.Currency;
import info.preva1l.fadah.currency.CurrencyRegistry;
import info.preva1l.fadah.records.Category;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface Listing {
    @NotNull
    public UUID getId();

    @NotNull
    public UUID getOwner();

    @NotNull
    public String getOwnerName();

    @NotNull
    public ItemStack getItemStack();

    @NotNull
    public String getCategoryID();

    @NotNull
    public String getCurrencyId();

    public double getTax();

    public long getCreationDate();

    public long getDeletionDate();

    public double getPrice();

    default public Currency getCurrency() {
        return CurrencyRegistry.get(this.getCurrencyId());
    }

    public Category getCategory();

    default public boolean isOwner(@NotNull Player player) {
        return player.getUniqueId().equals(this.getOwner());
    }

    default public boolean isOwner(@NotNull UUID uuid) {
        return this.getOwner().equals(uuid);
    }

    public CompletableFuture<Void> cancel(@NotNull Player var1);

    public boolean canBuy(@NotNull Player var1);

    public boolean isActive();

    default public CompletableFuture<Void> expire() {
        return this.expire(false);
    }

    public CompletableFuture<Void> expire(boolean var1);
}

