/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.records.listing;

import com.google.common.base.Preconditions;
import info.preva1l.fadah.currency.Currency;
import info.preva1l.fadah.currency.CurrencyRegistry;
import info.preva1l.fadah.records.listing.Listing;
import info.preva1l.fadah.records.post.Post;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ListingBuilder {
    protected final UUID ownerUuid;
    protected final String ownerName;
    protected ItemStack itemStack;
    protected Currency currency = CurrencyRegistry.getAll().getFirst();
    protected Double price;
    protected Double tax = 0.0;
    protected Long length = 0x6DDD00L;
    protected boolean biddable = false;

    public ListingBuilder(Player owner) {
        this.ownerUuid = owner.getUniqueId();
        this.ownerName = owner.getName();
    }

    public ListingBuilder(UUID ownerUuid, String ownerName) {
        this.ownerUuid = ownerUuid;
        this.ownerName = ownerName;
    }

    public ListingBuilder itemStack(@NotNull ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        this.itemStack = itemStack;
        return this;
    }

    public ListingBuilder currency(@NotNull Currency currency) {
        Preconditions.checkNotNull((Object)currency);
        this.currency = currency;
        return this;
    }

    public ListingBuilder price(double price) {
        this.price = price;
        return this;
    }

    public ListingBuilder tax(double tax) {
        this.tax = tax;
        return this;
    }

    public ListingBuilder length(long length) {
        this.length = length;
        return this;
    }

    public ListingBuilder biddable(boolean biddable) {
        this.biddable = biddable;
        return this;
    }

    public abstract Post toPost();

    @ApiStatus.Internal
    public abstract Listing build();
}

