/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.fadah.records.post;

import java.util.Objects;
import java.util.function.Consumer;

public class PostResult {
    public static final PostResult SUCCESS = new PostResult(0, "Success");
    public static final PostResult SUCCESS_ADVERT_FAIL = new PostResult(1, "Success (Advert Failed)");
    public static final PostResult RESTRICTED_ITEM = new PostResult(2, "Restricted Item");
    public static final PostResult MAX_LISTINGS = new PostResult(3, "Max Listings");
    private final int ordinal;
    private final String message;

    private PostResult(int ordinal, String message) {
        this.ordinal = ordinal;
        this.message = message;
    }

    public static PostResult custom(String message) {
        return new PostResult(-999, message);
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String message() {
        return this.message;
    }

    public boolean successful() {
        return this == SUCCESS || this == SUCCESS_ADVERT_FAIL;
    }

    public PostResult success(Consumer<PostResult> supplier) {
        if (this.successful()) {
            supplier.accept(this);
        }
        return this;
    }

    public PostResult failure(Consumer<PostResult> supplier) {
        if (!this.successful()) {
            supplier.accept(this);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostResult that = (PostResult)o;
        return this.ordinal == that.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.ordinal);
    }
}

