/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.bstats.bukkit.Metrics;
import ch.njol.skript.util.Version;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class SkriptParticle
extends JavaPlugin {
    private static SkriptParticle instance;
    private static SkriptAddon addon;
    private static Logger logger;

    @Nullable
    public static SkriptParticle getInstance() {
        return instance;
    }

    @Nullable
    public static SkriptAddon getAddonInstance() {
        return addon;
    }

    public static void info(String message) {
        if (logger == null) {
            return;
        }
        logger.info(message);
    }

    public static void warning(String message) {
        if (logger == null) {
            return;
        }
        logger.warning(message);
    }

    public static void severe(String message) {
        if (logger == null) {
            return;
        }
        logger.severe(message);
    }

    public static void debug(String message) {
        if (logger == null) {
            return;
        }
        if (Skript.debug()) {
            logger.info(message);
        }
    }

    public void onEnable() {
        PluginManager manager = this.getServer().getPluginManager();
        Plugin skript = manager.getPlugin("Skript");
        logger = this.getLogger();
        if (skript == null || !skript.isEnabled()) {
            SkriptParticle.severe("Could not find Skript! Make sure you have it installed and that it properly loaded. Disabling...");
            manager.disablePlugin((Plugin)this);
            return;
        }
        if (Skript.getVersion().compareTo(new Version(new int[]{2, 7, 0})) < 0) {
            SkriptParticle.severe("You are running an unsupported version of Skript. Please update to at least Skript 2.7.0. Disabling...");
            manager.disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        addon = Skript.registerAddon((JavaPlugin)this);
        addon.setLanguageFileDirectory("lang");
        try {
            addon.loadClasses("com.sovdee.skriptparticles", new String[0]);
        }
        catch (IOException error) {
            error.printStackTrace();
            manager.disablePlugin((Plugin)this);
            return;
        }
        new Metrics((Plugin)this, 18457);
        SkriptParticle.info("Successfully enabled skript-particle.");
    }

    public void onDisable() {
        instance = null;
        addon = null;
    }
}

