/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.particles.Particle;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Draw Particle - Skript-Particle")
@Description(value={"Draws a particle at a location. Syntax inspired by SkBee, so bee careful not to get the two confused.", "If you run into conflicts with SkBee, which you shouldn't, please report it immediately."})
@Examples(value={"draw flame particle at player", "draw 10 of dust particle using dustOption(red, 1) at player for player"})
@Since(value={"1.0.0"})
public class EffDrawParticle
extends Effect {
    private Expression<Particle> particles;
    private Expression<Location> locations;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.particles = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        this.players = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        List<Player> recipients = null;
        if (this.players != null) {
            recipients = List.of((Player[])this.players.getArray(event));
        }
        for (Particle particle : (Particle[])this.particles.getArray(event)) {
            particle = particle.clone();
            if (recipients != null) {
                particle.receivers(recipients);
            }
            for (Location location : (Location[])this.locations.getArray(event)) {
                particle.location(location).spawn();
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "draw " + this.particles.toString(event, debug) + " at " + this.locations.toString(event, debug) + " " + (String)(this.players != null ? "to " + this.players.toString(event, debug) : "");
    }

    static {
        Skript.registerEffect(EffDrawParticle.class, (String[])new String[]{"draw %customparticles% %directions% %locations% [(for|to) %-players%]"});
    }
}

