/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.elements.sections.DrawShapeEffectSection;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.Quaternion;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Name(value="Rotate Shape")
@Description(value={"Rotates shapes around a given axis by a given angle. The axis can be specified as a vector or as a single axis (x, y, or z). By default, the rotation is done in degrees.", "The axis can also be specified as a local or relative axis, which rotate relative to the shape's current rotation.", "For example, you can rotate a shape around the global y axis, or around the shape's local y axis."})
@Examples(value={"rotate shape {_shape} around x axis by 90 degrees", "rotate shape {_shape} around vector(0, 1, 0) by 1.4 radians", "rotate shape {_shape} around local y axis by 90"})
@Since(value={"1.0.0"})
public class EffRotateShape
extends Effect {
    private Expression<Shape> shapes;
    private boolean useDrawnShapes = false;
    private Expression<Vector> vectorAxis;
    private Expression<Number> angle;
    private Expression<Quaternionf> rotation;
    private String axis;
    private boolean relative = false;
    private boolean isRadians = false;
    private boolean isAxisAngle = false;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int offset = 0;
        if (matchedPattern >= 2) {
            if (!this.getParser().isCurrentEvent(DrawShapeEffectSection.DrawEvent.class)) {
                Skript.error((String)"You must supply a shape to rotate when using this effect outside of the draw shape section.");
                return false;
            }
            this.useDrawnShapes = true;
            offset = 1;
        } else {
            this.shapes = exprs[0];
        }
        if (matchedPattern % 2 == 1) {
            this.rotation = exprs[1 - offset];
            return true;
        }
        this.isAxisAngle = true;
        if (parseResult.hasTag("v")) {
            this.vectorAxis = exprs[1 - offset];
        } else {
            this.relative = parseResult.hasTag("relative");
            this.axis = parseResult.hasTag("x") ? "x" : (parseResult.hasTag("y") ? "y" : "z");
        }
        this.angle = exprs[2 - offset];
        this.isRadians = parseResult.hasTag("radians");
        return true;
    }

    protected void execute(Event event) {
        Quaternionf rotation;
        if (this.isAxisAngle) {
            Vector axis;
            Number angle = (Number)this.angle.getSingle(event);
            if (angle == null) {
                return;
            }
            if (!this.isRadians) {
                angle = Math.toRadians(angle.doubleValue());
            }
            if (this.axis != null) {
                switch (this.axis) {
                    case "x": {
                        axis = new Vector(1, 0, 0);
                        break;
                    }
                    case "y": {
                        axis = new Vector(0, 1, 0);
                        break;
                    }
                    case "z": {
                        axis = new Vector(0, 0, 1);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            } else {
                axis = (Vector)this.vectorAxis.getSingle(event);
                if (axis == null) {
                    return;
                }
            }
            rotation = new Quaternionf().rotationAxis((float)angle.doubleValue(), (float)axis.getX(), (float)axis.getY(), (float)axis.getZ());
        } else {
            rotation = (Quaternionf)this.rotation.getSingle(event);
            if (rotation == null) {
                return;
            }
        }
        Shape[] shapes = this.useDrawnShapes && event instanceof DrawShapeEffectSection.DrawEvent ? new Shape[]{((DrawShapeEffectSection.DrawEvent)event).getShape()} : (Shape[])this.shapes.getAll(event);
        for (Shape shape : shapes) {
            Quaternion orientation = shape.getOrientation();
            if (this.relative) {
                shape.setOrientation(orientation.mul((Quaternionfc)rotation));
                continue;
            }
            shape.setOrientation(orientation.premul((Quaternionfc)rotation));
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.rotation != null) {
            return "rotate shape " + (this.useDrawnShapes ? "drawn shapes" : this.shapes.toString(event, debug)) + " by " + this.rotation.toString(event, debug);
        }
        return "rotate shape " + (this.useDrawnShapes ? "drawn shapes" : this.shapes.toString(event, debug)) + " around " + (this.relative ? "relative " : "") + (this.vectorAxis != null ? "vector " + this.vectorAxis.toString(event, debug) : this.axis + " axis") + " by " + this.angle.toString(event, debug) + (this.isRadians ? " radians" : " degrees");
    }

    static {
        Skript.registerEffect(EffRotateShape.class, (String[])new String[]{"rotate shape[s] %shapes% around [relative:(relative|local)] (v:%-vector%|((:x|:y|:z)(-| )axis)) by %number% [degrees|:radians]", "rotate shape[s] %shapes% (by|with) [rotation] %quaternion%", "rotate [drawn] shape[s] around [relative:(relative|local)] (v:%-vector%|((:x|:y|:z)(-| )axis)) by %number% [degrees|:radians]", "rotate [drawn] shape[s] (by|with) [rotation] %quaternion%"});
    }
}

