/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Toggle Axes")
@Description(value={"Toggles the visibility of the local and/or global axes of a shape.", "When on, the shape will also draw its local and/or global axes when drawn.", "This is intended for debugging purposes."})
@Examples(value={"show local axes of {_shape}", "hide global axes of {_shape}", "hide local and global axes of {_shape}", "show local axes of {_shape} and {_shape2}"})
@Since(value={"1.0.0"})
public class EffToggleAxes
extends Effect {
    private Expression<Shape> shape;
    private boolean localFlag = false;
    private boolean globalFlag = false;
    private boolean showFlag = false;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.shape = expressions[0];
        this.localFlag = parseResult.hasTag("local");
        this.globalFlag = parseResult.hasTag("global");
        this.showFlag = parseResult.hasTag("show");
        return true;
    }

    protected void execute(Event event) {
        Shape[] shapes;
        for (Shape shape : shapes = (Shape[])this.shape.getArray(event)) {
            if (this.globalFlag) {
                shape.showGlobalAxes(this.showFlag);
            }
            if (!this.localFlag) continue;
            shape.showLocalAxes(this.showFlag);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (this.showFlag ? "show" : "hide") + (this.globalFlag ? "global" : "") + (this.globalFlag && this.localFlag ? " and " : "") + (this.localFlag ? "local" : "") + " axes of shapes " + this.shape.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffToggleAxes.class, (String[])new String[]{"(:show|:hide) [:local] [and] [:global] axes of [shape[s]] %shapes%"});
    }
}

