/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.particles.Particle;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle With Data")
@Description(value={"Creates a particle with data. This is useful for creating particles with data such as dust options, dust transitions, vibrations, etc.", "The particle can be created with a particle type, or a custom particle. If a custom particle is used, the particle will be cloned. If a count is not specified, it will default to 1.", "This syntax was based on SkBee's draw particle effect syntax, so please report any conflicts with SkBee immediately. There should not be any conflicts, but there's always a risk."})
@Examples(value={"set {_particle} to electric spark particle with extra 0", "set particle of {_shape} to dust particle using dustOption(red, 1) with force"})
public class ExprCustomParticle
extends SimpleExpression<Particle> {
    @Nullable
    private Expression<Number> count;
    private Expression<?> particle;
    @Nullable
    private Expression<Object> data;
    @Nullable
    private Expression<Vector> offset;
    @Nullable
    private Expression<Number> extra;
    private boolean force;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.count = exprs[0];
        this.particle = exprs[1];
        this.data = exprs[2];
        this.offset = exprs[3];
        this.extra = exprs[4];
        this.force = parseResult.hasTag("force");
        return true;
    }

    @Nullable
    protected Particle[] get(Event event) {
        Number extra;
        Vector offset;
        Particle particle;
        @Nullable Object particleExpr = this.particle.getSingle(event);
        if (particleExpr == null) {
            return new Particle[0];
        }
        if (particleExpr instanceof Particle) {
            particle = ((Particle)((Object)particleExpr)).clone();
        } else if (particleExpr instanceof org.bukkit.Particle) {
            particle = new Particle((org.bukkit.Particle)particleExpr);
        } else {
            return new Particle[0];
        }
        particle = particle.clone();
        if (this.count != null) {
            @Nullable Number count = (Number)this.count.getSingle(event);
            if (count != null) {
                particle.count(count.intValue());
            } else {
                particle.count(1);
            }
        }
        if (this.data != null) {
            @Nullable Object data = this.data.getSingle(event);
            if (data instanceof ItemType) {
                ItemType itemType = (ItemType)data;
                data = itemType.getRandom();
            }
            if (data != null) {
                particle.data(data);
            }
        }
        if (this.offset != null && (offset = (Vector)this.offset.getSingle(event)) != null) {
            particle.offset(offset.getX(), offset.getY(), offset.getZ());
        }
        if (this.extra != null && (extra = (Number)this.extra.getSingle(event)) != null) {
            particle.extra(extra.doubleValue());
        }
        if (this.force) {
            particle.force(true);
        }
        return new Particle[]{particle};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Particle> getReturnType() {
        return Particle.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "custom particle";
    }

    static {
        Skript.registerExpression(ExprCustomParticle.class, Particle.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[%-number% [of]] %customparticle/particle% particle[s] [using %-itemtype/blockdata/dustoption/dusttransition/vibration/number%] [with offset %-vector%] [with extra %-number%] [force:with force]"});
    }
}

