/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Copy")
@Description(value={"Returns a copy of the given shape. This is useful if you want a modified version of a shape without changing the original."})
@Examples(value={"set {_shape-2} to a copy of {_shape}", "set {_shape} to a copy of a sphere with radius 1"})
@Since(value={"1.0.0"})
public class ExprShapeCopy
extends SimpleExpression<Shape> {
    private Expression<Shape> shapeExpr;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.shapeExpr = expressions[0];
        return true;
    }

    protected Shape[] get(@NonNull Event event) {
        Shape[] shape = (Shape[])this.shapeExpr.getArray(event);
        if (shape.length == 0) {
            return new Shape[0];
        }
        ArrayList<Shape> copy = new ArrayList<Shape>();
        for (Shape value : shape) {
            copy.add(value.clone());
        }
        return copy.toArray(new Shape[0]);
    }

    public boolean isSingle() {
        return this.shapeExpr.isSingle();
    }

    public Class<? extends Shape> getReturnType() {
        return Shape.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "shape copy";
    }

    static {
        Skript.registerExpression(ExprShapeCopy.class, Shape.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] shape cop(y|ies) of %shapes%"});
    }
}

