/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Arc;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Arc or Sector")
@Description(value={"Creates an arc or sector with the given radius and cutoff angle. The radius must be greater than 0 and the height, if given, must be positive.", "The angle must be between 0 and 360 degrees. If the angle is 360 degrees, the shape will be a circle or cylinder.", "An arc is a portion of the circle's circumference. A sector is a portion of the circle's area."})
@Examples(value={"set {_shape} to an arc with radius 10 and angle 45 degrees", "set {_shape} to a circular sector of radius 3 and angle 90 degrees", "set {_shape} to a sector of radius 3 and height 5 and angle 90 degrees", "set {_shape} to a cylindrical sector of radius 1, height 0.5, and angle 45"})
@Since(value={"1.0.0"})
public class ExprArc
extends SimpleExpression<Arc> {
    private Expression<Number> radius;
    private Expression<Number> angle;
    private Expression<Number> height;
    private boolean isRadians = false;
    private boolean isSector = false;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        double c;
        Literal literal;
        this.radius = exprs[0];
        if (matchedPattern == 1) {
            this.height = exprs[1];
            this.angle = exprs[2];
        } else {
            this.angle = exprs[1];
        }
        this.isRadians = parseResult.hasTag("radians");
        this.isSector = parseResult.hasTag("sector");
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the arc must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.height;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 0.0) {
            Skript.error((String)("The height of the arc cannot be negative. (height: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.angle;
        if (expression instanceof Literal && ((c = ((Number)(literal = (Literal)expression).getSingle()).doubleValue()) <= 0.0 || c > 360.0)) {
            Skript.error((String)("The cutoff angle of the arc must be between 0 and 360. (angle: " + c + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected Arc[] get(Event event) {
        Number height;
        Number radius = (Number)this.radius.getSingle(event);
        Number angle = (Number)this.angle.getSingle(event);
        Number number = height = this.height != null ? (Number)((Number)this.height.getSingle(event)) : (Number)0;
        if (radius == null || angle == null || height == null) {
            return null;
        }
        if (!this.isRadians) {
            angle = Math.toRadians(angle.doubleValue());
        }
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        height = Math.max(height.doubleValue(), 0.0);
        angle = MathUtil.clamp(angle.doubleValue(), 0.0, Math.PI * 2);
        Arc arc = new Arc(radius.doubleValue(), height.doubleValue(), angle.doubleValue());
        if (this.isSector) {
            arc.setStyle(Shape.Style.FILL);
        }
        return new Arc[]{arc};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Arc> getReturnType() {
        return Arc.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (this.isSector ? "sector" : "arc") + " with radius " + this.radius.toString(event, debug) + " and angle " + this.angle.toString(event, debug) + (this.isRadians ? " radians " : " degrees ");
    }

    static {
        Skript.registerExpression(ExprArc.class, Arc.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [circular] (arc|:sector) (with|of) radius %number% and [cutoff] angle [of] %number% [degrees|:radians]", "[a[n]] [cylindrical] (arc|:sector) (with|of) radius %number%(,| and) height %-number%[,] and [cutoff] angle [of] %number% [degrees|:radians]"});
    }
}

