/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.BezierCurve;
import com.sovdee.skriptparticles.util.Point;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Bezier Curve")
@Description(value={"Creates a bezier curve between the given start and end points, using the given control points to change the curve."})
@Examples(value={"set {_shape} to a bezier curve from {a} to {b} with control points {c} and {d}", "set {_shape} to a curve from player to player's target with control point (location 3 above player)"})
@Since(value={"1.3.0"})
public class ExprBezierCurve
extends SimpleExpression<BezierCurve> {
    private Expression<?> start;
    private Expression<?> end;
    private Expression<?> controlPoints;

    public boolean init(Expression<?>[] exprs, int matchedPattern, @NonNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SkriptParser.ParseResult parseResult) {
        this.start = exprs[0];
        this.end = exprs[1];
        this.controlPoints = exprs[2];
        return true;
    }

    protected BezierCurve @Nullable [] get(@NonNull Event event) {
        @Nullable Point<?> start = Point.of(this.start.getSingle(event));
        @Nullable Point<?> end = Point.of(this.end.getSingle(event));
        if (start == null || end == null) {
            return null;
        }
        ArrayList controlPoints = new ArrayList();
        for (Object value : this.controlPoints.getArray(event)) {
            controlPoints.add(Point.of(value));
        }
        return new BezierCurve[]{new BezierCurve(start, end, controlPoints)};
    }

    public boolean isSingle() {
        return true;
    }

    public @NonNull Class<? extends BezierCurve> getReturnType() {
        return BezierCurve.class;
    }

    public @NonNull String toString(@Nullable Event event, boolean debug) {
        return "bezier curve between start " + this.start.toString(event, debug) + " and end " + this.end.toString(event, debug) + " using control points " + this.controlPoints.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBezierCurve.class, BezierCurve.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [bezier] curve from [start] %vector/entity/location% to [end] %vector/entity/location% (with|using) control point[s] %vectors/entities/locations%"});
    }
}

