/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Circle;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Circle or Cylinder")
@Description(value={"Creates a circle, disc, or cylinder shape with the given radius. The radius must be greater than 0 and the height cannot be negative."})
@Examples(value={"set {_shape} to circle with radius 10", "set {_shape} to a disc of radius 3", "set {_shape} to a solid cylinder with radius 3 and height 5"})
@Since(value={"1.0.0"})
public class ExprCircle
extends SimpleExpression<Circle> {
    private Expression<Number> radius;
    private Expression<Number> height;
    private Shape.Style style;
    private boolean isCylinder;

    public boolean init(Expression<?>[] exprs, int matchedPattern, @NonNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.isCylinder = matchedPattern == 1;
        this.radius = exprs[0];
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the " + (this.isCylinder ? "cylinder" : "circle") + " must be greater than 0. (radius: " + ((Number)((Literal)this.radius).getSingle()).doubleValue() + ")"));
            return false;
        }
        if (this.isCylinder) {
            this.height = exprs[1];
            expression = this.height;
            if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 0.0) {
                Skript.error((String)("The height of the cylinder must be greater than or equal to 0. (height: " + ((Number)((Literal)this.height).getSingle()).doubleValue() + ")"));
                return false;
            }
            this.style = switch (parseResult.mark) {
                case 0 -> Shape.Style.SURFACE;
                case 1 -> Shape.Style.OUTLINE;
                default -> Shape.Style.FILL;
            };
        } else {
            this.style = parseResult.hasTag("disc") ? Shape.Style.SURFACE : Shape.Style.OUTLINE;
        }
        return true;
    }

    @Nullable
    protected Circle[] get(@NonNull Event event) {
        Number height;
        Number radius = (Number)this.radius.getSingle(event);
        Number number = height = this.height != null ? (Number)((Number)this.height.getSingle(event)) : (Number)0;
        if (radius == null || height == null) {
            return null;
        }
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        height = Math.max(height.doubleValue(), 0.0);
        Circle circle = new Circle(radius.doubleValue(), height.doubleValue());
        circle.setStyle(this.style);
        return new Circle[]{circle};
    }

    public boolean isSingle() {
        return true;
    }

    public @NonNull Class<? extends Circle> getReturnType() {
        return Circle.class;
    }

    public @NonNull String toString(@Nullable Event event, boolean debug) {
        return this.isCylinder ? "circle of radius " + this.radius.toString(event, debug) : "cylinder of radius " + this.radius.toString(event, debug) + " and height " + (this.height != null ? this.height.toString(event, debug) : "0");
    }

    static {
        Skript.registerExpression(ExprCircle.class, Circle.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] (circle|:disc) (with|of) radius %number%", "[a] [hollow|2:solid] (cylinder|1:tube) (with|of) radius %number% and height %number%"});
    }
}

