/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Cuboid;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Cuboid")
@Description(value={"Creates a cuboid from a length, a width, and a height, or from two corners.", "The specified length, width, and height must be greater than 0. Length is the x-axis, width is the z-axis, and height is the y-axis.", "When defining a cuboid from two corners, the corners can either be vectors or locations/entities. You cannot use both vectors and locations/entities, but you can mix and match locations and entities.When using locations, this is a shape that can be drawn without a specific location. It will be drawn between the two given locations."})
@Examples(value={"set {_shape} to a solid cuboid with length 10, width 10, and height 10", "set {_shape} to a hollow cuboid from vector(-5, -5, -5) to vector(5, 5, 5)", "draw the shape of a cuboid from player to player's target"})
@Since(value={"1.0.0"})
public class ExprCuboid
extends SimpleExpression<Cuboid> {
    private Expression<Number> width;
    private Expression<Number> length;
    private Expression<Number> height;
    private Expression<?> corner1;
    private Expression<?> corner2;
    private int matchedPattern = 0;
    private Shape.Style style;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 0: {
                this.length = exprs[0];
                this.width = exprs[1];
                this.height = exprs[2];
                break;
            }
            case 1: {
                this.corner1 = exprs[0];
                this.corner2 = exprs[1];
            }
        }
        this.matchedPattern = matchedPattern;
        this.style = parseResult.hasTag("hollow") ? Shape.Style.SURFACE : (parseResult.hasTag("solid") ? Shape.Style.FILL : Shape.Style.OUTLINE);
        return true;
    }

    @Nullable
    protected Cuboid[] get(Event event) {
        Cuboid cuboid;
        if (this.matchedPattern == 0) {
            if (this.width == null || this.length == null || this.height == null) {
                return null;
            }
            Number width = (Number)this.width.getSingle(event);
            Number length = (Number)this.length.getSingle(event);
            Number height = (Number)this.height.getSingle(event);
            if (width == null || length == null || height == null) {
                return null;
            }
            width = Math.max(width.doubleValue(), 1.0E-4);
            length = Math.max(length.doubleValue(), 1.0E-4);
            height = Math.max(height.doubleValue(), 1.0E-4);
            cuboid = new Cuboid(width.doubleValue(), length.doubleValue(), height.doubleValue());
        } else {
            if (this.corner1 == null || this.corner2 == null) {
                return null;
            }
            Object corner1 = this.corner1.getSingle(event);
            Object corner2 = this.corner2.getSingle(event);
            if (corner1 == null || corner2 == null) {
                return null;
            }
            if (corner1 instanceof Vector && corner2 instanceof Vector) {
                cuboid = new Cuboid((Vector)corner1, (Vector)corner2);
            } else {
                if (corner1 instanceof Vector || corner2 instanceof Vector) {
                    return null;
                }
                corner1 = DynamicLocation.fromLocationEntity(corner1);
                corner2 = DynamicLocation.fromLocationEntity(corner2);
                if (corner1 == null || corner2 == null) {
                    return null;
                }
                cuboid = new Cuboid((DynamicLocation)corner1, (DynamicLocation)corner2);
            }
        }
        cuboid.setStyle(this.style);
        return new Cuboid[]{cuboid};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Cuboid> getReturnType() {
        return Cuboid.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (switch (this.style) {
            default -> throw new IncompatibleClassChangeError();
            case Shape.Style.FILL -> "filled ";
            case Shape.Style.SURFACE -> "hollow ";
            case Shape.Style.OUTLINE -> "outlined ";
        }) + "cuboid " + (String)(switch (this.matchedPattern) {
            case 0 -> "with width " + this.width.toString(event, debug) + ", length " + this.length.toString(event, debug) + ", and height " + this.height.toString(event, debug);
            case 1 -> "from " + this.corner1.toString(event, debug) + " to " + this.corner2.toString(event, debug);
            default -> "";
        });
    }

    static {
        Skript.registerExpression(ExprCuboid.class, Cuboid.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [:hollow|:solid] cuboid (with|of) length %number%(,| and) width %number%[,] and height %number%", "[a] [:hollow|:solid] cuboid (from|between) %location/entity/vector% (to|and) %location/entity/vector%"});
    }
}

