/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Ellipse;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Ellipse or Elliptical Cylinder")
@Description(value={"Creates a ellipse, elliptical disc, or elliptical cylinder shape with the given radii. The radii must be greater than 0.", "The first radius is the x radius, and the second radius is the z radius. These are relative to the shape's rotation, so they only correspond exactly to the x and z axes if the shape is not rotated.", "NOTE: Very eccentric elliptical discs/sectors (those with a large difference between the x and z radii) may have many more particles than expected. Be careful."})
@Examples(value={"set {_shape} to oval with radii 10 and 3", "set {_shape} to a solid ellipse of radius 3 and 5", "set {_shape} to a hollow elliptical cylinder with radii 3 and 6 and height 5"})
@Since(value={"1.0.0"})
public class ExprEllipse
extends SimpleExpression<Ellipse> {
    private Expression<Number> xRadius;
    private Expression<Number> zRadius;
    private Expression<Number> height;
    private Shape.Style style;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal literal;
        Expression<Number> expression;
        this.xRadius = exprs[0];
        this.zRadius = exprs[1];
        this.style = Shape.Style.OUTLINE;
        if (parseResult.hasTag("surface")) {
            this.style = Shape.Style.SURFACE;
        }
        if (matchedPattern == 1) {
            this.height = exprs[2];
            switch (parseResult.mark) {
                case 0: {
                    Shape.Style style = Shape.Style.SURFACE;
                    break;
                }
                case 1: {
                    Shape.Style style = Shape.Style.OUTLINE;
                    break;
                }
                default: {
                    Shape.Style style = this.style = Shape.Style.FILL;
                }
            }
        }
        if ((expression = this.xRadius) instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the ellipse must be greater than 0. (length radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.zRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the ellipse must be greater than 0. (width radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.height;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 0.0) {
            Skript.error((String)("The height of the elliptical cylinder must be greater than or equal to 0. (height: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected Ellipse[] get(Event event) {
        Number height;
        Number xRadius = (Number)this.xRadius.getSingle(event);
        Number zRadius = (Number)this.zRadius.getSingle(event);
        Number number = height = this.height == null ? (Number)0 : (Number)((Number)this.height.getSingle(event));
        if (xRadius == null || zRadius == null || height == null) {
            return null;
        }
        xRadius = Math.max(xRadius.doubleValue(), 1.0E-4);
        zRadius = Math.max(zRadius.doubleValue(), 1.0E-4);
        height = Math.max(height.doubleValue(), 0.0);
        Ellipse ellipse = new Ellipse(xRadius.doubleValue(), zRadius.doubleValue(), height.doubleValue());
        ellipse.setStyle(this.style);
        return new Ellipse[]{ellipse};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Ellipse> getReturnType() {
        return Ellipse.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.height == null ? "ellipse of x radius " + this.xRadius.toString(event, debug) + " and z radius " + this.zRadius.toString(event, debug) : "elliptical cylinder of x radius " + this.xRadius.toString(event, debug) + " and z radius " + this.zRadius.toString(event, debug) + " and height " + (this.height != null ? this.height.toString(event, debug) : "0");
    }

    static {
        Skript.registerExpression(ExprEllipse.class, Ellipse.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [surface:(solid|filled)] (ellipse|oval) (with|of) radi(i|us) %number% and %number%", "[a[n]] [hollow|2:solid] elliptical (cylinder|1:tube) (with|of) radi(i|us) %number%(,| and) %number%[,] and height %number%"});
    }
}

