/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Ellipsoid;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Ellipsoid")
@Description(value={"Creates a ellipsoid shape with the given radii. The radii must be greater than 0.", "The first radius is the x radius, and the second is the y radius, and the last is the z radius. These are relative to the shape's rotation, so they only correspond exactly to the world axes if the shape is not rotated.", "Note that this shape is modified using the Length/Width/Height modifiers, not the Radius modifier. This means the length/width/height of the shape will be twice the radius in each direction. Length is the x axis, width is the z axis, and height is the y axis.", "NOTE: Very eccentric solid ellipsoids (those with a large difference between the radii) may have many more particles than expected. Be careful."})
@Examples(value={"set {_shape} to ellipsoid with radii 10, 3, and 8", "set {_shape} to a solid ellipsoid of radius 3 and 5 and 6", "set {_shape} to a hollow ellipsoid with radii 3, 6 and 5"})
@Since(value={"1.0.0"})
public class ExprEllipsoid
extends SimpleExpression<Ellipsoid> {
    private Expression<Number> xRadius;
    private Expression<Number> yRadius;
    private Expression<Number> zRadius;
    private Shape.Style style;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.xRadius = exprs[0];
        this.yRadius = exprs[1];
        this.zRadius = exprs[2];
        Expression<Number> expression = this.xRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The x radius of the ellipsoid must be greater than 0. (x radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.yRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The y radius of the ellipsoid must be greater than 0. (y radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.zRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The z radius of the ellipsoid must be greater than 0. (z radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        this.style = parseResult.hasTag("hollow") ? Shape.Style.SURFACE : (parseResult.hasTag("fill") ? Shape.Style.FILL : Shape.Style.OUTLINE);
        return true;
    }

    @Nullable
    protected Ellipsoid[] get(Event event) {
        Number xRadius = (Number)this.xRadius.getSingle(event);
        Number yRadius = (Number)this.yRadius.getSingle(event);
        Number zRadius = (Number)this.zRadius.getSingle(event);
        if (xRadius == null || yRadius == null || zRadius == null) {
            return null;
        }
        xRadius = Math.max(xRadius.doubleValue(), 1.0E-4);
        yRadius = Math.max(yRadius.doubleValue(), 1.0E-4);
        zRadius = Math.max(zRadius.doubleValue(), 1.0E-4);
        Ellipsoid ellipsoid = new Ellipsoid(xRadius.doubleValue(), yRadius.doubleValue(), zRadius.doubleValue());
        ellipsoid.setStyle(this.style);
        return new Ellipsoid[]{ellipsoid};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Ellipsoid> getReturnType() {
        return Ellipsoid.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "ellipsoid with radii " + this.xRadius.toString(event, debug) + ", " + this.yRadius.toString(event, debug) + ", and " + this.zRadius.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprEllipsoid.class, Ellipsoid.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [(outlined|wireframe|:hollow|fill:(solid|filled))] ellipsoid (with|of) radi(i|us) %number%(,| and) %number%[,] and %number%"});
    }
}

