/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.EllipticalArc;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Elliptical Arc or Sector")
@Description(value={"Creates an elliptical arc or sector with the given radii and cutoff angle. The radii must be greater than 0 and the height, if given, must be positive.", "The angle must be between 0 and 360 degrees. If the angle is 360 degrees, the shape will be a ellipse or elliptical cylinder.", "An arc is a portion of the ellipse's circumference. A sector is a portion of the ellipse's area.", "NOTE: Very eccentric elliptical sectors (those with a large difference between the x and z radii) may have many more particles than expected. Be careful."})
@Examples(value={"set {_shape} to an elliptical arc with radii 10 and 3 and cutoff angle of 90 degrees", "set {_shape} to a elliptical sector of radius 3 and 5 and cutoff angle of 45 degrees", "set {_shape} to a elliptical cylinder with radii 3 and 5, height 10, and cutoff angle of 3.1415 radians"})
@Since(value={"1.0.0"})
public class ExprEllipticalArc
extends SimpleExpression<EllipticalArc> {
    private Expression<Number> xRadius;
    private Expression<Number> zRadius;
    private Expression<Number> height;
    private Expression<Number> angle;
    private Shape.Style style;
    private boolean isRadians;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        double c;
        Literal literal;
        Expression<Number> expression;
        this.xRadius = exprs[0];
        this.zRadius = exprs[1];
        if (matchedPattern == 1) {
            this.height = exprs[2];
            this.angle = exprs[3];
            expression = this.height;
            if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 0.0) {
                Skript.error((String)("The height of the arc cannot be negative. (height: " + ((Number)literal.getSingle()).doubleValue() + ")"));
                return false;
            }
        } else {
            this.angle = exprs[2];
        }
        if ((expression = this.xRadius) instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the ellipse must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.zRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the ellipse must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.angle;
        if (expression instanceof Literal && ((c = ((Number)(literal = (Literal)expression).getSingle()).doubleValue()) <= 0.0 || c > 360.0)) {
            Skript.error((String)("The cutoff angle of the arc must be between 0 and 360. (angle: " + c + ")"));
            return false;
        }
        this.style = parseResult.hasTag("sector") ? Shape.Style.FILL : Shape.Style.OUTLINE;
        this.isRadians = parseResult.hasTag("radians");
        return true;
    }

    @Nullable
    protected EllipticalArc[] get(Event event) {
        Number xRadius = (Number)this.xRadius.getSingle(event);
        Number zRadius = (Number)this.zRadius.getSingle(event);
        Number height = this.height == null ? (Number)0 : (Number)((Number)this.height.getSingle(event));
        Number angle = (Number)this.angle.getSingle(event);
        if (xRadius == null || zRadius == null || angle == null || height == null) {
            return null;
        }
        xRadius = Math.max(xRadius.doubleValue(), 1.0E-4);
        zRadius = Math.max(zRadius.doubleValue(), 1.0E-4);
        height = Math.max(height.doubleValue(), 0.0);
        if (!this.isRadians) {
            angle = Math.toRadians(angle.doubleValue());
        }
        angle = MathUtil.clamp(angle.doubleValue(), 0.0, Math.PI * 2);
        EllipticalArc arc = new EllipticalArc(xRadius.doubleValue(), zRadius.doubleValue(), height.doubleValue(), angle.doubleValue());
        arc.setStyle(this.style);
        return new EllipticalArc[]{arc};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends EllipticalArc> getReturnType() {
        return EllipticalArc.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (this.style == Shape.Style.FILL ? "sector" : "arc") + " with radius " + this.xRadius.toString(event, debug) + " and " + this.zRadius.toString(event, debug) + (String)(this.height == null ? "" : " and height " + this.height.toString(event, debug)) + " and angle " + this.angle.toString(event, debug) + (this.isRadians ? " radians " : " degrees ");
    }

    static {
        Skript.registerExpression(ExprEllipticalArc.class, EllipticalArc.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[an] elliptical (arc|:sector) (with|of) radi(i|us) %number%(,| and) %number%[,] and [cutoff] angle [of] %number% [degrees|:radians]", "[an] elliptical [cylindrical] (arc|:sector) (with|of) radi(i|us) %number%(,| and) %number%(,| and) height %-number%[,] and [cutoff] angle [of] %number% [degrees|:radians]"});
    }
}

