/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Heart;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Heart")
@Description(value={"Creates a heart shape with the given width and height, and optionally eccentricity. The width (x) and length (z) must be greater than 0.", "The eccentricity defaults to 3, but must be at least 1. This determines how round/pointy the heart is. Values between 1 and 5 are recommended.", "Note that the width and length are not exact, but they're roughly the width and length of the heart.", "Finally, this shape does not support the particle count expression and its particle density is not uniform. If anyone knows a good way to compute the complete elliptic integral of the second kind, please let me know."})
@Examples(value={"set {_heart} to heart with width 5 and length 4", "set {_heart} to heart shape with width 5, length 7, and eccentricity 2", "draw the shape of a heart of width 2 and length 2 at player"})
@Since(value={"1.0.1"})
public class ExprHeart
extends SimpleExpression<Heart> {
    private Expression<Number> width;
    private Expression<Number> length;
    private Expression<Number> eccentricity;
    private boolean isSolid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Literal literal;
        Expression<Number> expression;
        this.width = expressions[0];
        this.length = expressions[1];
        if (expressions.length > 2) {
            this.eccentricity = expressions[2];
        }
        if ((expression = this.width) instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)"The width of a heart must be greater than 0.");
            return false;
        }
        expression = this.length;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)"The length of a heart must be greater than 0.");
            return false;
        }
        expression = this.eccentricity;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)"The eccentricity of a heart must be greater than 1.");
            return false;
        }
        this.isSolid = parseResult.hasTag("solid");
        return true;
    }

    @Nullable
    protected Heart[] get(Event event) {
        Number eccentricity;
        Number width = (Number)this.width.getSingle(event);
        Number length = (Number)this.length.getSingle(event);
        Number number = eccentricity = this.eccentricity == null ? (Number)3 : (Number)((Number)this.eccentricity.getSingle(event));
        if (width == null || length == null || eccentricity == null) {
            return null;
        }
        width = Math.max(width.doubleValue(), 1.0E-4);
        length = Math.max(length.doubleValue(), 1.0E-4);
        eccentricity = Math.max(eccentricity.doubleValue(), 1.0);
        Heart heart = new Heart(width.doubleValue(), length.doubleValue(), eccentricity.doubleValue());
        if (this.isSolid) {
            heart.setStyle(Shape.Style.SURFACE);
        }
        return new Heart[]{heart};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Heart> getReturnType() {
        return Heart.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "a heart shape with width " + this.width.toString(event, debug) + ", height " + this.length.toString(event, debug) + (String)(this.eccentricity == null ? "" : ", and eccentricity " + this.eccentricity.toString(event, debug) + ".");
    }

    static {
        Skript.registerExpression(ExprHeart.class, Heart.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [:solid] heart [shape] (with|of) width %number%[,] [and] length %number%[[,] [and] eccentricity %-number%]"});
    }
}

