/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Helix;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.Nullable;

@Name(value="Particle Helix / Spiral")
@Description(value={"Creates a helix or spiral shape with the given radius and height. The radius and height must be greater than 0.", "The winding rate is the number of loops per meter or block. If omitted, the winding rate will be 1 loop per block.", "The height of the helix can be manipulated through both the length and height expressions."})
@Examples(value={"set {_shape} to helix with radius 10 and height 5", "set {_shape} to a spiral with radius 3 and height 5 and winding rate of 2 loops per meter", "set {_shape} to a solid anti-clockwise helix with radius 3, height 5, winding rate 1"})
@Since(value={"1.0.0"})
public class ExprHelix
extends SimpleExpression<Helix> {
    private Expression<Number> radius;
    private Expression<Number> height;
    private @Nullable Expression<Number> windingRate;
    private boolean isClockwise = true;
    private Shape.Style style;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.radius = exprs[0];
        this.height = exprs[1];
        if (exprs.length > 2) {
            this.windingRate = exprs[2];
        }
        this.isClockwise = parseResult.mark == 0;
        this.style = parseResult.hasTag("solid") ? Shape.Style.SURFACE : Shape.Style.OUTLINE;
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of a helix must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.height;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The height of a helix must be greater than 0. (height: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.windingRate;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The winding rate of a helix must be greater than 0. (winding rate: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        return true;
    }

    protected @Nullable Helix[] get(Event event) {
        Integer windingRate;
        @Nullable Number radius = (Number)this.radius.getSingle(event);
        @Nullable Number height = (Number)this.height.getSingle(event);
        Number number = windingRate = this.windingRate == null ? (Number)1 : (Number)((Number)this.windingRate.getSingle(event));
        if (radius == null || height == null || windingRate == null) {
            return new Helix[0];
        }
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        height = Math.max(height.doubleValue(), 1.0E-4);
        double slope = 1.0 / Math.max(((Number)windingRate).doubleValue(), 1.0E-4);
        int direction = this.isClockwise ? 1 : -1;
        Helix helix = new Helix(radius.doubleValue(), height.doubleValue(), slope / (Math.PI * 2), direction);
        helix.setStyle(this.style);
        return new Helix[]{helix};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Helix> getReturnType() {
        return Helix.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "a " + (this.isClockwise ? "clockwise" : "counter-clockwise") + " helix with radius " + this.radius.toString(event, debug) + ", height " + this.height.toString(event, debug) + (String)(this.windingRate == null ? "" : ", and winding rate " + this.windingRate.toString(event, debug));
    }

    static {
        Skript.registerExpression(ExprHelix.class, Helix.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [:solid] [[1:(counter|anti)[-]]clockwise] (helix|spiral) (with|of) radius %number%[,] [and] height %number%[[,] [and] winding rate [of] %-number% [loops per (meter|block)]]"});
    }
}

