/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.IrregularPolygon;
import com.sovdee.skriptparticles.util.DynamicLocation;
import java.io.Serializable;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Irregular Polygon")
@Description(value={"Creates an irregular polygon from a list of vectors or locations. If locations are used, the polygon can be drawn without giving a specific location to draw at.", "The height of the polygon will be the height between the lowest and highest points. It can also be set with the optional height parameter.", "", "Irregular polygons currently only support the wireframe style. Also, they do not currently support Dynamic Locations like lines and cuboids do."})
@Examples(value={"set {_shape} to a polygon with points vector(0, 0, 0), vector(1, 0, 0), and vector(1, 1, 1)", "set {_shape} to a 2d polygon from points vector(0,0,1), vector(1,0,1), vector(0,0,-1) and height 0.5"})
@Since(value={"1.0.0"})
public class ExprIrregularPolygon
extends SimpleExpression<IrregularPolygon> {
    private Expression<?> points;
    private Expression<Number> height;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal literal;
        Expression<Number> expression;
        this.points = exprs[0];
        if (exprs.length > 1 && (expression = (this.height = exprs[1])) instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 0.0) {
            Skript.error((String)("The height of the polygon must be greater than or equal to 0. (height: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected IrregularPolygon[] get(Event event) {
        Object[] points = this.points.getArray(event);
        ArrayList<Vector> vertices = new ArrayList<Vector>(points.length);
        Vector locationOffset = null;
        for (Object point : points) {
            if (point instanceof Vector) {
                vertices.add((Vector)point);
                continue;
            }
            if (!(point instanceof Location)) continue;
            if (locationOffset == null) {
                locationOffset = ((Location)point).toVector();
            }
            vertices.add(((Location)point).toVector().subtract(locationOffset));
        }
        Number height = this.height != null ? (Number)((Number)this.height.getSingle(event)) : (Number)null;
        IrregularPolygon polygon = height != null ? new IrregularPolygon(vertices, height.doubleValue()) : new IrregularPolygon(vertices);
        if (locationOffset != null) {
            polygon.setLocation(new DynamicLocation((Location)points[0]));
        }
        return new IrregularPolygon[]{polygon};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends IrregularPolygon> getReturnType() {
        return IrregularPolygon.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "2d polygon from points " + this.points.toString(event, debug) + " and height " + (Serializable)(this.height == null ? Integer.valueOf(0) : this.height.toString(event, debug));
    }

    static {
        Skript.registerExpression(ExprIrregularPolygon.class, IrregularPolygon.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [2d] polygon (from|with) [vertices|points] %vectors/locations% [and height %-number%]"});
    }
}

