/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Line;
import com.sovdee.skriptparticles.util.DynamicLocation;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Line")
@Description(value={"Creates a line shape between points, or in a direction for a given length. The length must be greater than 0.", "When defining a line from points, the points can either be vectors or locations/entities. Each point in the first set will connect to each point in the second set. You can use the third pattern to connect points in series, like a path along the points.", "", "You cannot use both vectors and locations/entities, but you can mix and match locations and entities.When using locations, this is a shape that can be drawn without a specific location. It will be drawn between the two given locations.", "If using vectors, or a direction and length, the shape does require a location to be drawn at."})
@Examples(value={"set {_shape} to line from vector(0, 0, 0) to vector(10, 10, 10)", "set {_shape} to a line in direction vector(1, 1, 1) and length 10", "draw the shape of a line from vector(0, 0, 0) to vector(10, 10, 10) at player", "", "# note that the following does not require a location to be drawn at", "draw the shape of a line from player to player's target", "draw the shape of a line from player to (all players in radius 10 of player)", "draw the shape of a line connecting {_locations::*}"})
@Since(value={"1.0.0"})
public class ExprLine
extends SimpleExpression<Line> {
    private Expression<?> start;
    private Expression<?> end;
    private Expression<?> points;
    private Expression<Vector> direction;
    private Expression<Number> length;
    private int matchedPattern = 0;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 0: {
                this.start = exprs[0];
                this.end = exprs[1];
                break;
            }
            case 1: {
                Literal literal;
                this.direction = exprs[0];
                Expression<Number> expression = this.length = exprs[1];
                if (!(expression instanceof Literal) || !(((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0)) break;
                Skript.error((String)"The length of a line must be greater than 0.");
                return false;
            }
            case 2: {
                this.points = exprs[0];
            }
        }
        this.matchedPattern = matchedPattern;
        return true;
    }

    @Nullable
    protected Line[] get(Event event) {
        ArrayList<Line> lines = new ArrayList<Line>();
        switch (this.matchedPattern) {
            case 0: {
                Object[] start = this.start.getArray(event);
                Object[] end = this.end.getArray(event);
                for (Object startObject : start) {
                    for (Object endObject : end) {
                        if (startObject instanceof Vector) {
                            Vector startVector = (Vector)startObject;
                            if (endObject instanceof Vector) {
                                Vector endVector = (Vector)endObject;
                                lines.add(new Line(startVector, endVector));
                                continue;
                            }
                        }
                        if (startObject instanceof Vector || endObject instanceof Vector) continue;
                        DynamicLocation startPoint = DynamicLocation.fromLocationEntity(startObject);
                        DynamicLocation endPoint = DynamicLocation.fromLocationEntity(endObject);
                        if (endPoint == null || startPoint == null) continue;
                        lines.add(new Line(startPoint, endPoint));
                    }
                }
                break;
            }
            case 1: {
                Vector v = (Vector)this.direction.getSingle(event);
                Number length = (Number)this.length.getSingle(event);
                if (v == null) {
                    return null;
                }
                if (length != null) {
                    v.multiply(Math.max(length.doubleValue(), 1.0E-4));
                }
                lines.add(new Line(v));
                break;
            }
            case 2: {
                Object[] points = this.points.getArray(event);
                if (points instanceof Vector[]) {
                    Vector[] vectors = (Vector[])points;
                    for (int i = 0; i < vectors.length - 1; ++i) {
                        lines.add(new Line(vectors[i], vectors[i + 1]));
                    }
                } else {
                    ArrayList<DynamicLocation> locations = new ArrayList<DynamicLocation>();
                    for (Object point : points) {
                        DynamicLocation location;
                        if (point instanceof Vector || (location = DynamicLocation.fromLocationEntity(point)) == null) continue;
                        locations.add(location);
                    }
                    for (int i = 0; i < locations.size() - 1; ++i) {
                        lines.add(new Line((DynamicLocation)locations.get(i), (DynamicLocation)locations.get(i + 1)));
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        return lines.toArray(new Line[0]);
    }

    public boolean isSingle() {
        return switch (this.matchedPattern) {
            case 0 -> {
                if (this.end.isSingle() && this.start.isSingle()) {
                    yield true;
                }
                yield false;
            }
            case 1, 2 -> true;
            default -> throw new IllegalStateException("invalid pattern " + this.matchedPattern);
        };
    }

    public Class<? extends Line> getReturnType() {
        return Line.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return switch (this.matchedPattern) {
            case 0 -> "a line from " + this.start.toString(event, debug) + " to " + this.end.toString(event, debug);
            case 1 -> "a line in direction " + this.direction.toString(event, debug) + " with length " + this.length.toString(event, debug);
            case 2 -> "a line connecting " + this.points.toString(event, debug);
            default -> "a line";
        };
    }

    static {
        Skript.registerExpression(ExprLine.class, Line.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] line[s] (from|between) %locations/entities/vectors% (to|and) %locations/entities/vectors%", "[a] line (in [the]|from) direction %vector% [(and|[and] with) length %number%]", "[a] line (between|connecting) %locations/entities/vectors%"});
    }
}

