/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Rectangle;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Rectangle")
@Description(value={"Creates a rectangle from a length and a width, or from two corners. The length and width must be greater than 0.", "When defining a rectangle from two corners, the corners can either be vectors or locations/entities. You cannot use both vectors and locations/entities, but you can mix and match locations and entities. When using locations, this is a shape that can be drawn without a specific location. It will be drawn between the two given locations.", "Note that the rectangle defaults to the xz plane, or parallel to the ground, with x being width and z being length. You can change this to the xy or yz plane by using the 'xy' or 'yz'. In all cases, the first axis is length and the second is width."})
@Examples(value={"set {_shape} to rectangle with length 10 and width 5", "set {_shape} to a yz rectangle from vector(0, 0, 0) to vector(10, 10, 10)", "draw the shape of a rectangle with length 10 and width 5 at player", "", "# note that the following does not require a location to be drawn at", "draw the shape of a rectangle from player to player's target"})
@Since(value={"1.0.0"})
public class ExprRectangle
extends SimpleExpression<Rectangle> {
    private Expression<Number> lengthExpr;
    private Expression<Number> widthExpr;
    private Shape.Style style;
    private Expression<?> corner1Expr;
    private Expression<?> corner2Expr;
    private int matchedPattern;
    private Rectangle.Plane plane;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.style = parseResult.hasTag("solid") ? Shape.Style.SURFACE : Shape.Style.OUTLINE;
        this.matchedPattern = matchedPattern;
        if (matchedPattern == 0) {
            this.lengthExpr = exprs[0];
            this.widthExpr = exprs[1];
        } else {
            this.corner1Expr = exprs[0];
            this.corner2Expr = exprs[1];
        }
        this.plane = Rectangle.Plane.XZ;
        if (parseResult.hasTag("xy")) {
            this.plane = Rectangle.Plane.XY;
        } else if (parseResult.hasTag("yz")) {
            this.plane = Rectangle.Plane.YZ;
        }
        return true;
    }

    @Nullable
    protected Rectangle[] get(Event event) {
        Rectangle rectangle;
        if (this.matchedPattern == 0) {
            if (this.lengthExpr == null || this.widthExpr == null) {
                return null;
            }
            Number length = (Number)this.lengthExpr.getSingle(event);
            Number width = (Number)this.widthExpr.getSingle(event);
            if (length == null || width == null) {
                return null;
            }
            length = Math.max(length.doubleValue(), 1.0E-4);
            width = Math.max(width.doubleValue(), 1.0E-4);
            rectangle = new Rectangle(length.doubleValue(), width.doubleValue(), this.plane);
        } else {
            if (this.corner1Expr == null || this.corner2Expr == null) {
                return null;
            }
            Object corner1 = this.corner1Expr.getSingle(event);
            Object corner2 = this.corner2Expr.getSingle(event);
            if (corner1 == null || corner2 == null) {
                return null;
            }
            if (corner1 instanceof Vector && corner2 instanceof Vector) {
                rectangle = new Rectangle((Vector)corner1, (Vector)corner2, this.plane);
            } else {
                if (corner1 instanceof Vector || corner2 instanceof Vector) {
                    return null;
                }
                corner1 = DynamicLocation.fromLocationEntity(corner1);
                corner2 = DynamicLocation.fromLocationEntity(corner2);
                if (corner1 == null || corner2 == null) {
                    return null;
                }
                rectangle = new Rectangle((DynamicLocation)corner1, (DynamicLocation)corner2, this.plane);
            }
        }
        rectangle.setStyle(this.style);
        return new Rectangle[]{rectangle};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Rectangle> getReturnType() {
        return Rectangle.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = this.style == Shape.Style.SURFACE ? "solid " : "";
        return string + (switch (this.plane) {
            default -> throw new IncompatibleClassChangeError();
            case Rectangle.Plane.XZ -> " xz ";
            case Rectangle.Plane.XY -> " xy ";
            case Rectangle.Plane.YZ -> " yz ";
        }) + (String)(switch (this.matchedPattern) {
            case 0 -> "rectangle with length " + this.lengthExpr.toString(event, debug) + " and width " + this.widthExpr.toString(event, debug);
            case 1 -> "rectangle from " + this.corner1Expr.toString(event, debug) + " to " + this.corner2Expr.toString(event, debug);
            default -> "";
        });
    }

    static {
        Skript.registerExpression(ExprRectangle.class, Rectangle.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [solid:(solid|filled)] [:xz|:xy|:yz] rectangle (with|of) length %number% and width %number%", "[a[n]] [solid:(solid|filled)] [:xz|:xy|:yz] rectangle (from|with corners [at]) %location/entity/vector% (to|and) %location/entity/vector%"});
    }
}

