/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.RegularPolygon;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Regular Polygon")
@Description(value={"Creates a regular polygon with the given number of sides and radius. The number of sides must be at least 3. The radius must be greater than 0."})
@Examples(value={"set {_shape} to a regular polygon with 5 sides and radius 10", "set {_shape} to a solid regular polygon with 6 sides and side length 3", "draw the shape of a triangle with side length 5 at player"})
public class ExprRegularPolygon
extends SimpleExpression<RegularPolygon> {
    private Expression<Number> radius;
    private Expression<Number> sideLength;
    private Expression<Number> sides;
    private Shape.Style style;
    private int matchedPattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.style = parseResult.hasTag("solid") ? Shape.Style.SURFACE : Shape.Style.OUTLINE;
        this.matchedPattern = matchedPattern;
        switch (matchedPattern) {
            case 0: {
                this.sides = exprs[0];
                this.radius = exprs[1];
                break;
            }
            case 1: {
                this.sides = exprs[0];
                this.sideLength = exprs[1];
                break;
            }
            case 2: {
                this.sides = new SimpleLiteral((Object)parseResult.mark, false);
                this.radius = exprs[0];
                break;
            }
            case 3: {
                this.sides = new SimpleLiteral((Object)parseResult.mark, false);
                this.sideLength = exprs[0];
            }
        }
        Expression<Number> expression = this.sides;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).intValue() < 3) {
            Skript.error((String)("The number of sides must be at least 3. (sides: " + literal.getSingle() + ")"));
            return false;
        }
        expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius must be greater than 0. (radius: " + literal.getSingle() + ")"));
            return false;
        }
        expression = this.sideLength;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The side length must be greater than 0. (side length: " + literal.getSingle() + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected RegularPolygon[] get(Event event) {
        Number radius;
        Number sides = (Number)this.sides.getSingle(event);
        if (sides == null) {
            return null;
        }
        if (this.matchedPattern % 2 == 0) {
            radius = (Number)this.radius.getSingle(event);
            if (radius == null) {
                return null;
            }
        } else {
            radius = (Number)this.sideLength.getSingle(event);
            if (radius == null) {
                return null;
            }
            radius = radius.doubleValue() / (2.0 * Math.sin(Math.PI / sides.doubleValue()));
        }
        sides = Math.max(sides.intValue(), 3);
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        RegularPolygon polygon = new RegularPolygon(sides.intValue(), radius.doubleValue());
        polygon.setStyle(this.style);
        return new RegularPolygon[]{polygon};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends RegularPolygon> getReturnType() {
        return RegularPolygon.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = this.style == Shape.Style.SURFACE ? "filled" : "outlined";
        return string + (String)(switch (this.matchedPattern) {
            case 0, 2 -> " regular polygon with " + this.sides.toString(event, debug) + " sides and radius " + this.radius.toString(event, debug);
            case 1, 3 -> " regular polygon with " + this.sides.toString(event, debug) + " sides and side length " + this.sideLength.toString(event, debug);
            default -> "regular polygon";
        });
    }

    static {
        Skript.registerExpression(ExprRegularPolygon.class, RegularPolygon.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [solid:(solid|filled)] regular polygon with %number% sides and radius %number%", "[a] [solid:(solid|filled)] regular polygon with %number% sides and side length %number%", "[a[n]] [solid:(solid|filled)] (3:[equilateral ]triangle|4:square|5:pentagon|6:hexagon|7:heptagon|8:octagon) with radius %number%", "[a[n]] [solid:(solid|filled)] (3:[equilateral ]triangle|4:square|5:pentagon|6:hexagon|7:heptagon|8:octagon) with side length %number%"});
    }
}

