/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.RegularPolyhedron;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Regular Polyhedron")
@Description(value={"Creates a regular polyhedron shape with the given radius. The radius must be greater than 0.", "Valid polyhedra are tetrahedra (4 faces), octahedra (8), dodecahedra (12), and icosahedra (20).", "", "Polyhedra currently do not support the particle count expression, only particle density."})
@Examples(value={"set {_shape} to a tetrahedron with radius 1", "set {_shape} to a solid icosahedron with radius 2", "draw the shape of a tetrahedron with radius 5 at player"})
public class ExprRegularPolyhedron
extends SimpleExpression<RegularPolyhedron> {
    private Expression<Number> radius;
    private int faces;
    private Shape.Style style;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.radius = expressions[0];
        int n = parseResult.hasTag("tetra") ? 4 : (parseResult.hasTag("octa") ? 8 : (this.faces = parseResult.hasTag("dodeca") ? 12 : 20));
        this.style = parseResult.hasTag("hollow") ? Shape.Style.SURFACE : (parseResult.hasTag("solid") ? Shape.Style.FILL : Shape.Style.OUTLINE);
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the polyhedron must be greater than 0. (radius: " + ((Number)((Literal)this.radius).getSingle()).doubleValue() + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected RegularPolyhedron[] get(Event event) {
        if (this.radius.getSingle(event) == null) {
            return new RegularPolyhedron[0];
        }
        RegularPolyhedron regularPolyhedron = new RegularPolyhedron(((Number)this.radius.getSingle(event)).doubleValue(), this.faces);
        regularPolyhedron.setStyle(this.style);
        return new RegularPolyhedron[]{regularPolyhedron};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends RegularPolyhedron> getReturnType() {
        return RegularPolyhedron.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "regular polyhedron with " + this.faces + " faces with radius " + this.radius.toString(event, b);
    }

    static {
        Skript.registerExpression(ExprRegularPolyhedron.class, RegularPolyhedron.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a[n]] [outlined|:hollow|:solid] (:tetra|:octa|:icosa|:dodeca)hedron (with|of) radius %number%"});
    }
}

