/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.Sphere;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Sphere")
@Description(value={"Creates a sphere shape with the given radius. The radius must be greater than 0.", "Default style is a hollow sphere, but you can use the 'solid' tag to make it solid."})
@Examples(value={"set {_shape} to sphere with radius 3", "set {_shape} to solid sphere with radius 10"})
@Since(value={"1.0.0"})
public class ExprSphere
extends SimpleExpression<Sphere> {
    private Expression<Number> radius;
    private boolean isSolid;

    public boolean init(Expression<?>[] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.radius = exprs[0];
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the sphere must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        this.isSolid = parseResult.hasTag("solid");
        return true;
    }

    protected Sphere[] get(@NotNull Event event) {
        Number radius = (Number)this.radius.getSingle(event);
        if (radius == null) {
            return null;
        }
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        Sphere sphere = new Sphere(radius.doubleValue());
        if (this.isSolid) {
            sphere.setStyle(Shape.Style.FILL);
        }
        return new Sphere[]{sphere};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Sphere> getReturnType() {
        return Sphere.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "sphere with radius " + this.radius.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprSphere.class, Sphere.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [:solid] sphere (with|of) radius %number%"});
    }
}

