/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.SphericalCap;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Spherical Cap")
@Description(value={"Creates a spherical cap or spherical sector shape with the given radius and cutoff angle. The radius must be greater than 0.", "The angle must be between 0 and 180 degrees. If the angle is 180 degrees, the shape will be a sphere.", "A spherical cap is a portion of the surface of a sphere. A spherical sector, or spherical cone, is essentially a cone with a rounded base."})
@Examples(value={"set {_shape} to spherical cap with radius 10 and angle 45 degrees", "set {_shape} to a spherical sector of radius 3 and angle 90 degrees"})
@Since(value={"1.0.0"})
public class ExprSphericalCap
extends SimpleExpression<SphericalCap> {
    private Expression<Number> radius;
    private Expression<Number> angle;
    private boolean isRadians = false;
    private boolean isSector = false;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        double c;
        Literal literal;
        this.radius = exprs[0];
        this.angle = exprs[1];
        this.isRadians = parseResult.hasTag("radians");
        this.isSector = parseResult.hasTag("sector");
        Expression<Number> expression = this.radius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)("The radius of the spherical cap must be greater than 0. (radius: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.angle;
        if (expression instanceof Literal && ((c = ((Number)(literal = (Literal)expression).getSingle()).doubleValue()) <= 0.0 || c > 180.0)) {
            Skript.error((String)("The cutoff angle of the spherical cap must be between 0 and 180. (angle: " + c + ")"));
            return false;
        }
        return true;
    }

    @Nullable
    protected SphericalCap[] get(Event event) {
        Number radius = (Number)this.radius.getSingle(event);
        Number angle = (Number)this.angle.getSingle(event);
        if (radius == null || angle == null) {
            return null;
        }
        radius = Math.max(radius.doubleValue(), 1.0E-4);
        if (!this.isRadians) {
            angle = Math.toRadians(angle.doubleValue());
        }
        SphericalCap cap = new SphericalCap(radius.doubleValue(), angle.doubleValue());
        if (this.isSector) {
            cap.setStyle(Shape.Style.FILL);
        }
        return new SphericalCap[]{cap};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends SphericalCap> getReturnType() {
        return SphericalCap.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "spherical " + (this.isSector ? "sector" : "cap") + " with radius " + this.radius.toString(event, debug) + " and angle " + this.angle.toString(event, debug) + (this.isRadians ? " radians" : " degrees");
    }

    static {
        Skript.registerExpression(ExprSphericalCap.class, SphericalCap.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] spherical (cap|:sector) (with|of) radius %number% and [cutoff] angle [of] %number% [degrees|:radians]"});
    }
}

