/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.constructors;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.Star;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Particle Star")
@Description(value={"Creates a star shape with the given number of points, inner radius, and outer radius. The number of points must be at least 2, and the inner and outer radii must be greater than 0.", "Note that \"points\" in this context is referring to the tips of the star, not the number of particles."})
@Examples(value={"set {_shape} to star with 5 points, inner radius 1, and outer radius 2", "draw the shape of a star with 4 points, inner radius 2, and outer radius 4 at player"})
public class ExprStar
extends SimpleExpression<Star> {
    private Expression<Number> points;
    private Expression<Number> innerRadius;
    private Expression<Number> outerRadius;
    private boolean isSolid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Literal literal;
        this.points = expressions[0];
        this.innerRadius = expressions[1];
        this.outerRadius = expressions[2];
        this.isSolid = parseResult.hasTag("solid");
        Expression<Number> expression = this.points;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() < 2.0) {
            Skript.error((String)("A star must have at least 2 points. (points: " + ((Number)literal.getSingle()).doubleValue() + ")"));
            return false;
        }
        expression = this.innerRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)"The inner radius of a star must be greater than 0.");
            return false;
        }
        expression = this.outerRadius;
        if (expression instanceof Literal && ((Number)(literal = (Literal)expression).getSingle()).doubleValue() <= 0.0) {
            Skript.error((String)"The outer radius of a star must be greater than 0.");
            return false;
        }
        return true;
    }

    @Nullable
    protected Star[] get(Event event) {
        Number points = (Number)this.points.getSingle(event);
        Number innerRadius = (Number)this.innerRadius.getSingle(event);
        Number outerRadius = (Number)this.outerRadius.getSingle(event);
        if (points == null || innerRadius == null || outerRadius == null) {
            return null;
        }
        double angle = Math.PI * 2 / (double)Math.max(points.intValue(), 2);
        innerRadius = Math.max(innerRadius.doubleValue(), 1.0E-4);
        outerRadius = Math.max(outerRadius.doubleValue(), 1.0E-4);
        Star star = new Star(innerRadius.doubleValue(), outerRadius.doubleValue(), angle);
        if (this.isSolid) {
            star.setStyle(Shape.Style.SURFACE);
        }
        return new Star[]{star};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Star> getReturnType() {
        return Star.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "a " + (this.isSolid ? "solid " : "") + "star shape with " + this.points.toString(event, b) + " points, inner radius " + this.innerRadius.toString(event, b) + ", and outer radius " + this.outerRadius.toString(event, b);
    }

    static {
        Skript.registerExpression(ExprStar.class, Star.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [:solid] star with %number% points(,| and) inner radius %number%[,] and outer radius %number%"});
    }
}

