/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Helix;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Helix Winding Rate")
@Description(value={"Gets or sets the winding rate of a helix. The winding rate is the number of times the helix wraps around the axis per block.", "The default winding rate is 1 loop per block, which delete or reset will set it to. The winding rate must be positive and non-zero."})
@Examples(value={"set {_helix} to helix with radius 5, height 10, and winding rate 2 loops per block", "set winding rate of {_helix} to 1", "set winding rate of {_helix} to 1/10", "set winding rate of {_helix} to 10.4"})
@Since(value={"1.0.0"})
public class ExprHelixWindingRate
extends SimplePropertyExpression<Shape, Number> {
    @Nullable
    public Number convert(Shape shape) {
        if (shape instanceof Helix) {
            Helix helix = (Helix)shape;
            return 1.0 / (Math.PI * 2 * helix.getSlope());
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case DELETE: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            default: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Shape[] helices = (Shape[])this.getExpr().getArray(event);
        if (delta == null && mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
            return;
        }
        double deltaValue = delta == null ? 1.0 : ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                deltaValue = -deltaValue;
            }
            case ADD: {
                for (Shape shape : helices) {
                    if (!(shape instanceof Helix)) continue;
                    Helix helix = (Helix)shape;
                    helix.setSlope(helix.getSlope() / (1.0 + helix.getSlope() * deltaValue * 2.0 * Math.PI));
                }
                break;
            }
            case SET: 
            case DELETE: 
            case RESET: {
                for (Shape shape : helices) {
                    if (!(shape instanceof Helix)) continue;
                    Helix helix = (Helix)shape;
                    helix.setSlope(1.0 / (Math.PI * 2 * deltaValue));
                }
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "winding rate";
    }

    static {
        ExprHelixWindingRate.register(ExprHelixWindingRate.class, Number.class, (String)"winding rate", (String)"shapes");
    }
}

