/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.CutoffShape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Cutoff Angle")
@Description(value={"The cutoff angle of a shape in degrees. This determines the portion of the whole shape that will be drawn in shapes like arcs and spherical caps. For example, a cutoff angle of 90 on an arc will create a quarter of a circle.", "Note that an arc can range from 0 to 360 degrees, while a spherical cap can range from 0 to 180 degrees."})
@Examples(value={"set {_shape}'s cutoff angle to 90", "set cutoff angle of {_shape} to 180", "reset {_shape}'s cutoff angle"})
@Since(value={"1.0.0"})
public class ExprShapeCutoffAngle
extends SimplePropertyExpression<CutoffShape, Number> {
    @Nullable
    public Number convert(CutoffShape cutoffShape) {
        return cutoffShape.getCutoffAngle();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        double angle = 0.0;
        if (delta != null && delta.length != 0) {
            angle = ((Number)delta[0]).doubleValue();
        }
        angle = Math.toRadians(angle);
        switch (mode) {
            case REMOVE: {
                angle = -angle;
            }
            case ADD: {
                for (CutoffShape cutoffShape : (CutoffShape[])this.getExpr().getArray(event)) {
                    cutoffShape.setCutoffAngle(cutoffShape.getCutoffAngle() + angle);
                }
                break;
            }
            case SET: 
            case RESET: 
            case DELETE: {
                for (CutoffShape cutoffShape : (CutoffShape[])this.getExpr().getArray(event)) {
                    cutoffShape.setCutoffAngle(angle);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "cutoff angle";
    }

    static {
        ExprShapeCutoffAngle.register(ExprShapeCutoffAngle.class, Number.class, (String)"cutoff angle", (String)"cutoffshapes");
    }
}

