/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.LWHShape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Length/Width/Height")
@Description(value={"The length, width, or height of a shape. Changing this will change the size of the shape. Resetting or deleting it will set it back to the default value of 1."})
@Examples(value={"set {_shape}'s shape length to 5", "set {_shape}'s shape width to 5", "set {_shape}'s shape height to 5", "reset {_shape}'s shape length", "reset {_shape}'s shape width", "add 6 to {_shape}'s shape height"})
@Since(value={"1.0.0"})
public class ExprShapeLWH
extends SimplePropertyExpression<LWHShape, Number> {
    private int lwh;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lwh = parseResult.hasTag("length") ? 0 : (parseResult.hasTag("width") ? 1 : 2);
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(LWHShape lwhShape) {
        return switch (this.lwh) {
            case 0 -> lwhShape.getLength();
            case 1 -> lwhShape.getWidth();
            case 2 -> lwhShape.getHeight();
            default -> null;
        };
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            default: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        double value = 1.0;
        if (delta != null && delta.length != 0) {
            value = ((Number)delta[0]).doubleValue();
        }
        switch (mode) {
            case REMOVE: {
                value = -value;
            }
            case ADD: {
                block15: for (LWHShape shape : (LWHShape[])this.getExpr().getArray(event)) {
                    switch (this.lwh) {
                        case 0: {
                            shape.setLength(shape.getLength() + value);
                            continue block15;
                        }
                        case 1: {
                            shape.setWidth(shape.getWidth() + value);
                            continue block15;
                        }
                        case 2: {
                            shape.setHeight(shape.getHeight() + value);
                        }
                    }
                }
                break;
            }
            case SET: 
            case DELETE: 
            case RESET: {
                block16: for (LWHShape shape : (LWHShape[])this.getExpr().getArray(event)) {
                    switch (this.lwh) {
                        case 0: {
                            shape.setLength(value);
                            continue block16;
                        }
                        case 1: {
                            shape.setWidth(value);
                            continue block16;
                        }
                        case 2: {
                            shape.setHeight(value);
                        }
                    }
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return switch (this.lwh) {
            case 0 -> "length";
            case 1 -> "width";
            case 2 -> "height";
            default -> "unknown";
        };
    }

    static {
        ExprShapeLWH.register(ExprShapeLWH.class, Number.class, (String)"shape (:length|:width|:height)", (String)"lwhshapes");
    }
}

