/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Name(value="Shape Locations")
@Description(value={"Returns all the locations that particles would be spawned at if the shape was centered at the given location.", "If you want the vectors relative to the center of the shape, use the 'shape points' expression."})
@Examples(value={"set {_locations::*} to point locations of (circle of radius 10) centered at player", "teleport player to random element of {_locations::*}", "", "# drawing the shape yourself: (skbee particle syntax)", "draw 1 dust using dustOptions(red, 1) at (particle locations of (circle of radius 10) centered at player)"})
@Since(value={"1.0.0"})
public class ExprShapeLocations
extends SimpleExpression<Location> {
    private Expression<Shape> shapeExpr;
    private Expression<Location> locationExpr;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.shapeExpr = exprs[0];
        this.locationExpr = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    protected @Nullable Location[] get(Event event) {
        Shape[] shapes = (Shape[])this.shapeExpr.getAll(event);
        if (shapes.length == 0) {
            return new Location[0];
        }
        @Nullable Location center = (Location)this.locationExpr.getSingle(event);
        if (center == null) {
            return new Location[0];
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Shape shape : shapes) {
            locations.addAll(shape.getPoints().stream().map(point -> center.clone().add(point)).toList());
        }
        return locations.toArray(new Location[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public @NonNull Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public @NonNull String toString(@Nullable Event event, boolean debug) {
        return "Locations of shapes";
    }

    static {
        Skript.registerExpression(ExprShapeLocations.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(particle|point) locations of %shapes% [[centered] %direction% %location%]"});
    }
}

